/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990, 1991, 1992 BecknerVision Inc - All Rights Reserved

    Written by John Wm Beckner        THIS NOTICE MUST NOT BE REMOVED
    BecknerVision Inc
    PO Box 11945                      SOURCE CODE (THIS FILE) MAY NOT BE
    Winston-Salem NC 27116            DISTRIBUTED!  ONLY REGISTERED USERS
    Fax: 919/760-1003                 OF BECKNER LIBRARY & UTILITIES II MAY
                                      BE IN POSSESSION OF THIS FILE.
*/

#include "beckner.inc"

MEMVAR aReport

#include "alias.ch"
#include "set.ch"
#include "fileio.ch"
#define DELIMITER Chr(255)
#define nPageLength  aReport[1]
#define nPageWidth   aReport[2]
#define nLeftMargin  aReport[3]
#define nRightMargin aReport[4]
#define lDoubleSpace aReport[5]
#define lPlainReport aReport[6]
#define lEjectBefore aReport[7]
#define lEjectAfter  aReport[8]
#define lSummaryOnly aReport[9]
#define lPrintFinal  aReport[10]
#define aReportHdr   aReport[11]
#define aPageHdr     aReport[12]
#define aPageFtr     aReport[13]
#define aReportFtr   aReport[14]
#define aGroup       aReport[15]
#define aColumn      aReport[16]
#define aEval        aReport[17]
#define aFile        aReport[18]
#define _MAIN_       (Select(aReport[18, 1, 2]))
#define _FILENAME_   1
#define _ALIAS_      2
#define _INDICES_    3
#define _RELS_       4
#define _FILTER_     5
#xtranslate BEGIN BLOCK  => WHILE LOOPING
#xtranslate ENDBLOCK     => ENDWHILE
#xtranslate IS UNDEFINED => = NIL

FUNCTION pReport(cFile, cOutDevice, lEcho2Console, lPlain, lNoEject, lSummary,;
   cHeading, bFor, bWhile, nNextRecs, nRecord, lRest)
   LOCAL lReturn := .n., nPage := 0, nDetailLine, nReportLine, aReport, nCtr
   LOCAL lPrtStatus, lConStatus
   BEGIN BLOCK
      IF cFile IS UNDEFINED
         EXIT
      ENDIF
      DEFAULT cOutDevice      TO Set(_SET_PRINTFILE)
      DEFAULT lEcho2Console   TO .y.
      DEFAULT bFor            TO {||.y.}
      DEFAULT bWhile          TO {||!eof()}
      DEFAULT lRest           TO .n.
      IF Empty(aReport := fReadBVR(cFile))
         EXIT
      ENDIF
      FOR nCtr := 1 TO Len(aFile)                        /* open/set up files   */
         iif(Empty(aFile[nCtr, _ALIAS_]),;
               aFile[nCtr, _ALIAS_] := aFile[nCtr, _FILENAME_],)
         iif(Select(aFile[nCtr, _ALIAS_])=0, fShare(aFile[nCtr, _FILENAME_]),)
         fOpenIndices(aFile[nCtr, _INDICES_], aFile[nCtr, _ALIAS_])
         iif(!Empty(aFile[nCtr, _FILTER_]),;
               dbSetFilter({||&(aFile[nCtr, _FILTER_])},;
               aFile[nCtr, _FILTER_]),)
      NEXT
      FOR nCtr := 1 TO Len(aFile)                        /* set relations       */
         fSetRelations(aFile[nCtr, _RELS_], aFile[nCtr, _ALIAS_])
      NEXT
      SELECT _MAIN_
      iif(!lRest, dbGoTop(),)
      FOR nCtr := 1 to Len(aEval)                        /* preliminary data    */
         iif(Left(aEval[nCtr], 1)="0", Eval({||&(aEval[nCtr])}),)
      NEXT
      lPrtStatus := Set(_SET_PRINTER, .y.)               /* turn on printer     */
      lConStatus := Set(_SET_CONSOLE, lEcho2Console)     /* set console status  */
      FOR nCtr := 1 TO Len(aReportHdr)                   /* print report hdr    */
         PrintLine(&(aReportHdr[nCtr]), lDoubleSpace)
      NEXT
      WHILE Eval(bWhile)
         IF !Eval(bFor)
            SKIP
            LOOP
         ENDIF
         iif(pRow()>nPageLength .or. nPage=0,;
         NewPage(@nPage, aPageHdr, lDoubleSpace),)
         SKIP
      ENDWHILE
   ENDBLOCK
ENDFUNCTION

STATIC FUNCTION NewPage(nPage, aHeader, lDblSpc)
   LOCAL nCtr
   IF nPage>0
      EJECT
   ENDIF
   nPage++
   FOR nCtr := 1 TO Len(aPageHdr)                        /* print page hdr      */
      PrintLine(&(aPageHdr[nCtr]), lDblSpc)
   NEXT
ENDFUNCTION

STATIC FUNCTION PrintLine(cLine, lDblSpc)
   ?? cLine
   ?
   iif(lDblSpc, Qout(),)
ENDFUNCTION
