/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990, 1991, 1992 BecknerVision Inc - All Rights Reserved

    Written by John Wm Beckner        THIS NOTICE MUST NOT BE REMOVED
    BecknerVision Inc
    PO Box 11945                      SOURCE CODE (THIS FILE) MAY NOT BE
    Winston-Salem NC 27116            DISTRIBUTED!  ONLY REGISTERED USERS
    Fax: 919/760-1003                 OF BECKNER LIBRARY & UTILITIES II MAY
                                      BE IN POSSESSION OF THIS FILE.
*/

#include "beckner.inc"

FUNCTION iEnvironment(lSaving)
   STATIC aEnvironment[397]
   LOCAL nCtr
   MEMVAR GetList
   IF Type("GetList")="U"
      PRIVATE GetList := {}
   ENDIF
   IF lSaving
      aEnvironment[1]  := Select()               // Current work area
      aEnvironment[2]  := Used()                 // File open in work area?
      aEnvironment[3]  := iif(Empty(Alias()), 0, IndexOrd()) // Master index number
      aEnvironment[4]  := SaveScreen(0, 0, MaxRow(), MaxCol()) // Current screen
      aEnvironment[5]  := GetList                // Current GETS
      aEnvironment[6]  := Row()                  // Cursor position
      aEnvironment[7]  := Col()                  // ""
      aEnvironment[8]  := pRow()                 // Printhead position
      aEnvironment[9]  := pCol()                 // ""
      aEnvironment[10] := dbFilter()             // Current filter
      aEnvironment[11] := RecNo()                // Current record
      aEnvironment[12] := SetColor()             // Color settings
      aEnvironment[13] := SetCursor()            // Cursor shape
      FOR nCtr := 1 to 37
         aEnvironment[nCtr+13] := Set(nCtr)      // All sets
      NEXT
      FOR nCtr := -39 to 306
         aEnvironment[90+nCtr] := SetKey(nCtr)   // Key sets
      NEXT
      aEnvironment[397] := iShare()
   ELSE
      IF aEnvironment[1]=NIL
         RETURN NIL
      ENDIF
      SELECT (aEnvironment[1])
      IF aEnvironment[2]
         IF !Empty(Alias())
            SET ORDER to (aEnvironment[3])
            SET FILTER to (aEnvironment[10])
            IF aEnvironment[11]>0
               GO aEnvironment[11]
            ENDIF
         ENDIF
      ENDIF
      RestScreen(0, 0, MaxRow(), MaxCol(), aEnvironment[4])
      GetList := aEnvironment[5]
      SetColor(aEnvironment[12])
      SetCursor(aEnvironment[13])
      FOR nCtr := 1 TO 37
         Set(nCtr, aEnvironment[nCtr+13])
      NEXT
      FOR nCtr := -39 TO 306
         SetKey(nCtr, aEnvironment[90+nCtr])
      NEXT
      iShare(aEnvironment[397])
   ENDIF
ENDFUNCTION

/*
 1.02 02.06.93 Made CA-Clipper 5.2 compatible
*/
