/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"
#include "inkey.ch"

////////////////
////////////////
//
// Purpose:
//    Sets a filter interactively
//
// Syntax:
//    fSetFilter() -> NIL
//
// Formal Arguments: (0)
//
// Returns:
//    NIL
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       CreateTest()
//       /* try entering "Over21", which will limit browse to 3 records */
//       fSetFilter()      /* set a user-defined filter       */
//       fBrowse()         /* browse database to check filter */
//       CLOSE Test
//    ENDFUNCTION
//
//    #include "alias.ch"
//    STATIC FUNCTION CreateTest()
//       fCreateDbf("Test/Name/C/32/Balance/N/12/2/Date/D/Over21/L/Notes/M")
//       USE Test NEW EXCLUSIVE
//       ADDRECORD ALIAS Test
//       Test->Name    := "Abbott, Jake"
//       Test->Balance := 0.00
//       Test->Date    := CtoD("9/26/94")
//       Test->Over21  := .y.
//       Test->Notes   := ""
//       ADDRECORD ALIAS Test
//       Test->Name    := "Beckner, John Wm"
//       Test->Balance := 15000.00
//       Test->Date    := CtoD("9/26/94")
//       Test->Over21  := .y.
//       Test->Notes   := "These are notes!"
//       ADDRECORD ALIAS Test
//       Test->Name    := "Beckner, Elizabeth Anne"
//       Test->Balance := 0.58
//       Test->Date    := CtoD("12/18/96")
//       Test->Over21  := .n.
//       Test->Notes   := ""
//       ADDRECORD ALIAS Test
//       Test->Name    := "Beckner, Joseph Alan"
//       Test->Balance := 1.68
//       Test->Date    := CtoD("6/10/98")
//       Test->Over21  := .n.
//       Test->Notes   := "These are too!"
//       ADDRECORD ALIAS Test
//       Test->Name    := "Zumundi, Beavis"
//       Test->Balance := 123.45
//       Test->Date    := CtoD("")
//       Test->Over21  := .y.
//       Test->Notes   := ""
//       GO TOP
//    ENDFUNCTION
//
// Files:
//    (current work area)
//
// Description:
//    Interactively prompts the user for a filter string, then sets it.  User
//    may press <F2> to get a current work area field list.
//
// Category:
//    File Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION fSetFilter()
   STATIC cFilter
   LOCAL bKeySet, cLine, GetList := {}
   DEFAULT cFilter TO Space(300)
   cLine   := vSave(MaxRow(), 0, MaxRow(), MaxCol())
   bKeySet := SetKey(K_F2, {||fFieldList()})
   @ MaxRow(), 0
   @ MaxRow(), 0 SAY 'Enter filter: ' GET cFilter PICTURE '@KS70'
   READ
   SetKey(K_F2, bKeySet)
   SET FILTER to &(Trim(cFilter))
ENDFUNCTION
