/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Returns the number of open indices
//
// Syntax:
//    fIndexCount() -> nIndices
//
// Formal Arguments: (0)
//
// Returns:
//    nIndices    Number of open index files in the current work area
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       fCreate("Test/Name/C/25")
//       USE Test
//       INDEX ON Upper(Field->Name) TO Test
//       ? fIndexCount()      /* 1 */
//       CLOSE
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Returns the number of index files open in the current work area.
//
// Category:
//    File Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION fIndexCount()
   LOCAL nCounter := 0
   WHILE !Empty(IndexKey(++nCounter))
   ENDWHILE
   RETURN nCounter
ENDFUNCTION
