/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990, 1991, 1992 BecknerVision Inc - All Rights Reserved

    Written by John Wm Beckner        THIS NOTICE MUST NOT BE REMOVED
    BecknerVision Inc
    PO Box 11945                      SOURCE CODE (THIS FILE) MAY NOT BE
    Winston-Salem NC 27116            DISTRIBUTED!  ONLY REGISTERED USERS
    Fax: 919/760-1003                 OF BECKNER LIBRARY & UTILITIES II MAY
                                      BE IN POSSESSION OF THIS FILE.
*/

#include "beckner.inc"

#include "fileio.ch"
#include "alias.ch"

FUNCTION fFixDBF(cName, cNewName)
   LOCAL lLegalMark, dUpdated, nLastRec, nStart, nRecSize, nOffset, nTemp := 0
   LOCAL aFieldInfo := {}, GetList := {}, nInput, aRC, nCtr, nTemp2, nCtr2
   LOCAL lShift := .n., lDone := .n., cTemp, nOption
   DEFAULT cNewName to "$Beckner"
   vSave()
   aRC := vWindow(20, 78, .y., "Beckner File Fixer")
   @ aRC[1],  aRC[2] SAY "Input file ............. "+cName
   @ Row()+1, aRC[2] SAY "Output file ............ "+cNewName
   @ Row()+1, aRC[2] SAY "Valid DBF Id? .......... "
   iif(!fExtension(cName), cName := fExtNew(cName, "DBF"), )
   IF !File(cName)
      Alert("The INPUT FILE does not exist.;;Aborting.")
      vRestore()
      RETURN NIL
   ENDIF
   nInput     := fOpen(cName)
   cTemp      := fReadStr(nInput, 1)
   lLegalMark := cTemp$Chr(3)+Chr(131)
   @ Row(),    Col() SAY YesNo(lLegalMark)
   IF !lLegalMark
      nOption := Alert("The file identification mark is "+sMake(Asc(cTemp))+;
            ".;;This is not correct. Should I correct it?",;
            {"Yes", "No", "Abort"})
      IF nOption=0 .or. nOption=3
         vRestore()
         RETURN NIL
      ENDIF
   ENDIF
   cTemp      := fReadStr(nInput, 3)
   dUpdated   := CtoD(sMake(Asc(SubStr(cTemp, 2, 1)))+"."+;
                 sMake(Asc(Right(cTemp, 1)))+"."+sMake(Asc(Left(cTemp, 1))))
   nLastRec   := bLong2Num(fReadStr(nInput, 4)) /* bWord2Num(c2Byte, lSigned := .n.) */
   nStart     := bInt2Num(fReadStr(nInput, 2))
   nRecSize   := bInt2Num(fReadStr(nInput, 2))
   nOffset    := nStart
   fReadStr(nInput, 20) /* throw away filler */
   aAdd(aFieldInfo, {"(del mark)", "X", 1, , })
   WHILE (cTemp := fReadStr(nInput, 1))!=CR
      aAdd(aFieldInfo, {cTemp+fReadStr(nInput, 10),;
            Left(fReadStr(nInput, 5), 1),;
            0, 0, NIL})
      nTemp := Len(aFieldInfo)
      IF aFieldInfo[nTemp, 2]="C"
         aFieldInfo[nTemp, 3] := bInt2Num(fReadStr(nInput, 2))
      ELSEIF aFieldInfo[nTemp, 2]="N"
         aFieldInfo[nTemp, 3] := Asc(fReadStr(nInput, 1))
         aFieldInfo[nTemp, 4] := Asc(fReadStr(nInput, 1))
      ELSE
         aFieldInfo[nTemp, 3] := Asc(fReadStr(nInput, 2))
      ENDIF
      fReadStr(nInput, 14) /* throw away filler */
   ENDWHILE
   /* Create Output File */
   cTemp := cNewName
   FOR nCtr := 2 TO nTemp
      cTemp += "/"+aFieldInfo[nCtr, 1]+"/"+aFieldInfo[nCtr, 2]
      IF aFieldInfo[nCtr, 2]$"NC"
         cTemp += "/"+sMake(aFieldInfo[nCtr, 3])
      ENDIF
      IF aFieldInfo[nCtr, 2]="N"
         cTemp += "/"+sMake(aFieldInfo[nCtr, 4])
      ENDIF
   NEXT
   fCreateDBF(cTemp)
   fNoShare(cNewName, "Fixed")
   @ aRC[1]+3,  aRC[2] SAY "Valid Structure? ....... Yes"
   @ aRC[1]+4,  aRC[2] SAY "Records ................"
   @ Row(), Col()+1 SAY nLastRec PICTURE "9,999,999"
   @ Row()+1,   aRC[2] SAY "Current Record ........."
   /* Begin data analysis based on structure */
   fSeek(nInput, nStart, FS_SET)
   FOR nCtr := 1 TO nLastRec
      @ aRC[1]+5, aRC[2]+25 SAY nCtr PICTURE "9,999,999"
      BEGIN BLOCK
         /* Input Data into array */
         IF Len(cTemp  := fReadStr(nInput, nRecSize))!=nRecSize
            lDone := .y.
         ENDIF
         nTemp  := 1
         nTemp2 := Len(aFieldInfo)
         FOR nCtr2 := 1 TO nTemp2
            aFieldInfo[nCtr2, 5] := SubStr(cTemp, nTemp, aFieldInfo[nCtr2, 3])
            nTemp += aFieldInfo[nCtr2, 3]
         NEXT
         /* Analyze current record */
         FOR nCtr2 := 1 TO nTemp2
            DO CASE
            CASE aFieldInfo[nCtr2, 2]="X"
               lShift := !sValidChars(aFieldInfo[nCtr2, 5], " *")
            CASE aFieldInfo[nCtr2, 2]="D"
               lShift := !sValidChars(aFieldInfo[nCtr2, 5], " 1234567890")
            CASE aFieldInfo[nCtr2, 2]="N"
               lShift := !sValidChars(aFieldInfo[nCtr2, 5], " 1234567890.-");
                     .or. Len(sMake(aFieldInfo[nCtr2, 5]))>aFieldInfo[nCtr2, 3]
            CASE aFieldInfo[nCtr2, 2]="L"
               lShift := !sValidChars(aFieldInfo[nCtr2, 5], " TF")
            CASE aFieldInfo[nCtr2, 2]="M"
               lShift := .n.
            CASE aFieldInfo[nCtr2, 2]="C"
               lShift := !sCharRange(aFieldInfo[nCtr2, 5], 32, 127)
            ENDCASE
            IF lShift
               EXIT
            ENDIF
         NEXT
         IF lShift
            fSeek(nInput, -nRecSize+1, FS_RELATIVE)
            LOOP
         ENDIF
      END BLOCK
      IF lDone
         EXIT
      ENDIF
      /* write data */
      ADDRECORD ALIAS Fixed
      fEval({|cField, nField| FieldPut(nField,;
            sChar2Type(aFieldInfo[nField+1, 5], FieldGet(nField)))})
      iif(aFieldInfo[1, 5]="*", dbDelete(), )
   NEXT
ENDFUNCTION

STATIC FUNCTION YesNo(lYesNo)
   RETURN iif(lYesNo, "Yes", "No")
ENDFUNCTION
