/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Removes the extension from a filename
//
// Syntax:
//    fExtOff(<cOldName>) -> cNewName
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    cOldName    Old file name
//
// Returns:
//    cNewName    New file name, with no extension
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL cTest := "test.dbf"
//       ? fExtOff(cTest)        /* "test" */
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Removes the extension from a file name.
//
// See Also:
//    fExtNone()
//    fExtension()
//    fExtNew()
//
// Category:
//    File Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION fExtOff(cFilename)
   LOCAL cTemp
   RETURN Left(cTemp := fExtNew(cFilename, "x"), Len(cTemp)-2)
ENDFUNCTION
