/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"
#include "dbstruct.ch"

////////////////
////////////////
//
// Purpose:
//    Make basic FRM report from database structure
//
// Syntax:
//    fDbf2Frm([<cName>]) -> NIL
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    cName       FRM name [Alias()]
//
// Returns:
//    NIL
//
// Examples:
//
// Files:
//    (cName).db?/frm
//
// Description:
//    Makes a basic FRM file from the current database structure.  The
//    default filename is the database alias name plus ".FRM".
//
// See Also:
//    fCreateFrm()
//
// Category:
//    File Function
//
// Revisions:
//    02/28/94 Created
//
////////////////
////////////////

FUNCTION fDbf2Frm(cName)
   LOCAL aReport[19], nCtr, aStructure
   DEFAULT cName TO Alias()
   aReport[1]  := ALias()+" List"
   aFill(aReport, "", 2, 3)
   aReport[5]  := 0
   aFill(aReport, 0, 6, 2)
   aReport[8]  := 58
   aFill(aReport, .n., 9, 2)
   aReport[11] := .y.
   aReport[12] := .n.
   aFill(aReport, "", 13, 2)
   aFill(aReport, .n., 15, 2)
   aFill(aReport, "", 17, 2)
   aReport[19] := fCount()
   aStructure  := dbStruct()
   FOR nCtr := 1 TO aReport[19]
      aAdd(aReport, Array(9))
      aReport[nCtr+19, 1]  := iif(aStructure[nCtr, DBS_TYPE]="M",;
            15, aStructure[nCtr, DBS_LEN])
      aReport[nCtr+19, 2]  := (aStructure[nCtr, DBS_DEC]>0)
      aReport[nCtr+19, 3]  := aStructure[nCtr, DBS_DEC]
      aReport[nCtr+19, 4]  := iif(aStructure[nCtr, DBS_TYPE]="L",;
            "Transform("+aStructure[nCtr, DBS_NAME]+", 'Y')",;
            aStructure[nCtr, DBS_NAME])
      aReport[nCtr+19, 5]  := iif(aStructure[nCtr, DBS_TYPE]="L",;
            SubStr(aStructure[nCtr, DBS_NAME], 1, 1),;
            Trim(sSetLength(aStructure[nCtr, DBS_NAME], aStructure[nCtr, DBS_LEN])))
      aReport[nCtr+19, 6]  := iif(aStructure[nCtr, DBS_TYPE]="L",;
            SubStr(aStructure[nCtr, DBS_NAME], 2, 1), "")
      aReport[nCtr+19, 7]  := iif(aStructure[nCtr, DBS_TYPE]="L",;
            SubStr(aStructure[nCtr, DBS_NAME], 3, 1), "")
      aReport[nCtr+19, 8]  := iif(aStructure[nCtr, DBS_TYPE]="L",;
            SubStr(aStructure[nCtr, DBS_NAME], 4, 1), "")
      aReport[nCtr+19, 9]  := nCtr
      aReport[5]           += aStructure[nCtr, DBS_LEN]+1
   NEXT
   IF aReport[5]>80
      aReport[5] := 132
   ELSE
      aReport[5] := 80
   ENDIF
   fCreateFrm(cName, aReport)
ENDFUNCTION
