/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//
//
// Syntax:
//    f([<p>]) -> NIL
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    name        desc
//
// Returns:
//    name        desc
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL G
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Full
//
// See Also:
//    x
//
// Category:
//    File Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION fAverage(cFields)
   LOCAL nRecNum, nCount := 0, aAnswers := {}, aFieldName := {}, nTemp
   LOCAL nCtr := 0
   WHILE !Empty(cFields)
      aAdd(aAnswers, 0)
      aAdd(aFieldName, sParse(@cFields))
   ENDWHILE
   nRecNum := RecNo()
   dbEval({|| aEval(aFieldName,;
         {|cName, nElement| aAnswers[nElement] += &(cName)}), nCount++})
   aEval(aAnswers,;
         {|nTotal, nElement| aAnswers[nElement] := mDivide(nTotal, nCount)})
   RETURN aAnswers
ENDFUNCTION
