/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"
#include "set.ch"

////////////////
////////////////
//
// Purpose:
//    Returns a date which is the same day of the month as the passed date
//
// Syntax:
//    f([<dStart>], [<nMonths>]) -> dNew
//
// Formal Arguments: (2)
//    Name        Description
//    ___________ ____________
//    dStart      Any date [Date()]
//    nMonths     Number of months, may be negative or positive [1]
//
// Returns:
//    dNew        New date which is <nMonths> from <dStart>
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL dTest := CtoD("6/10/94")
//       ? dSame(dTest)          /* 07/10/94 */
//       ? dSame(dTest, 6)       /* 01/10/95 */
//       ? dSame(dTest, -6)      /* 01/10/94 */
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Returns a date which is a certain number of months before or after the
//    specified date, which defaults to the current system date.  The default
//    number of months is 1.  If the number of months is negative, then the
//    returned date is before <dStart>.
//
// Category:
//    Date Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION dSame(dBase, nNumMonths)
   LOCAL nMM, nDD, nYY, dTemp
   DEFAULT nNumMonths TO 1, dBase TO Date()
   nMM := Month(dBase)+nNumMonths
   nDD := Day(dBase)
   nYY := Year(dBase)-Set(_SET_EPOCH)
   WHILE nMM>12
      nMM -= 12
      iif(++nYY=100, nYY := 0,)
   ENDWHILE
   WHILE nMM<1
      nMM += 12
      iif(--nYY=-1, nYY := 99,)
   ENDWHILE
   dTemp := CtoD(Str(nMM, 2)+'/'+Str(nDD, 2)+'/'+Str(nYY, 2))
   WHILE Empty(dTemp)
      IF --nDD=0
         RETURN dEmpty()
      ENDIF
      dTemp := CtoD(Str(nMM, 2)+'/'+Str(nDD, 2)+'/'+Str(nYY, 2))
   ENDWHILE
   RETURN dTemp
ENDFUNCTION
