/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Returns a PICTURE value for a specified date
//
// Syntax:
//    dPicture(<dAny>) -> cPicture
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    dAny        Any date
//
// Returns:
//    cPicture    PICTURE clause
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL dTest1 := dEmpty(), dTest2 := CtoD("9/26/99")
//       CLS
//       @ 1, 0 SAY dTest1 PICTURE dPicture(dTest1)   /* " <none> " */
//       @ 2, 0 SAY dTest2 PICTURE dPicture(dTest2)   /* "09/26/99" */
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Returns a PICTURE for a date type, either " <none> " if the date is
//    empty, or "99/99/99" if not empty.  The returned string can be used
//    in either an @...SAY...PICTURE clause or a Transform() function.  <dAny>
//    would be the Transform() or SAY variable.
//
// Category:
//    Date Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION dPicture(dDate)
   IF Empty(dDate)
      RETURN ' <none> '
   ENDIF
   RETURN '99/99/99'
ENDFUNCTION
