/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/
#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Returns the last date in the year
//
// Syntax:
//    dEndYear([<dAny>]) -> dLast
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    dAny        Any date [Date()]
//
// Returns:
//    dLast       Last date in the year
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL dTest := CtoD("6/10/87")
//       ? dEndYear(dTest)       /* 12/31/87 */
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Returns the last date in the year, specifically December 31st of the
//    same year as <dAny> is in.
//
// See Also:
//    dBegYear()
//    dEndMonth()
//    dEndQuarter()
//
// Category:
//    Date Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION dEndYear(dAny)
   RETURN CtoD("12.31."+Right(DtoC(iif(dAny=NIL, Date(), dAny)), 2))
ENDFUNCTION
