/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Returns the date of the end of the quarter
//
// Syntax:
//    dEndQuarter([<dTest>]) -> dEnd
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    dTest       Any date
//
// Returns:
//    dEnd        Last date in quarter in which dTest is in
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL dAny := CtoD("9/26/98")
//       ? dEndQuarter(dAny)             /* 09/30/98 */
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Returns the last date of the quarter specified in <dTest>.
//
// See Also:
//    dBegQuarter()
//    dBegMonth()
//    dEndMonth()
//    dDaysLeftQ()
//    dDaysGoneQ()
//
// Category:
//    Date Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION dEndQuarter(dDate)
   IF Str(Month(dDate),2)$' 2, 5, 8,11'
      RETURN dEndMonth(dSame(dDate))
   ELSEIF Str(Month(dDate),2)$' 1, 4, 7,10'
      RETURN dEndMonth(dSame(dDate,2))
   ENDIF
   RETURN dEndMonth(dDate)
ENDFUNCTION
