/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990, 1991, 1992 BecknerVision Inc - All Rights Reserved

    Written by John Wm Beckner        THIS NOTICE MUST NOT BE REMOVED
    BecknerVision Inc
    PO Box 11945                      SOURCE CODE (THIS FILE) MAY NOT BE
    Winston-Salem NC 27116            DISTRIBUTED!  ONLY REGISTERED USERS
    Fax: 919/760-1003                 OF BECKNER LIBRARY & UTILITIES II MAY
                                      BE IN POSSESSION OF THIS FILE.
*/

#include "beckner.inc"

#include "fileio.ch"
#include "error.ch"

STATIC bDefaultErrors

FUNCTION pErrorSys(cSystem)
	LOCAL nSpaceHolder, oTooLow
	DEFAULT cSystem TO "unspecified"
	bDefaultErrors := ErrorBlock({|oError| BecknerError(oError, cSystem)})
	IF DiskSpace()<=1024
      oTooLow                 := ErrorNew()
      oTooLow:args            := {}
      oTooLow:canDefault      := oTooLow:canRetry := oTooLow:canSubstitute := .n.
      oTooLow:description     := "Disk space too low"
      oTooLow:filename        := oTooLow:operation := ""
      oTooLow:genCode         := 501
      oTooLow:osCode          := oTooLow:subCode := 0
      oTooLow:severity        := ES_CATASTROPHIC
      oTooLow:subSystem       := "BECKNER"
		BecknerError(oTooLow)
	ENDIF
	IF !File("SpaceHol.d")
		nSpaceHolder := fCreate("SpaceHol.d")
		fWrite(nSpaceHolder, " ", 1)
		fClose(nSpaceHolder)
	ENDIF
ENDFUNCTION

STATIC FUNCTION BecknerError(oError, cSystem)
	LogError("{"+cSystem+"} "+MakeMsg(oError))
	/* last ditch, use default error handler */
   RETURN Eval(bDefaultErrors, oError)
ENDFUNCTION

STATIC FUNCTION LogError(cErrMsg)
	LOCAL nErrFile := iif(File("ErrorLog.txt"),;
			fOpen("ErrorLog.txt", FO_WRITE),;
			fCreate("ErrorLog.txt"))
	fSeek(nErrFile, 0, FS_END)
	fWriteLine(nErrFile, cErrMsg)
	fClose(nErrFile)
ENDFUNCTION

STATIC FUNCTION MakeMsg(oError)
	RETURN sMake(Date())+" "+Time()+" "+;
			sExtract("INFORMATION,WARNING,ERROR,CATASTROPHY", ",",;
			oError:Severity+1)+": "+;
			iif(ValType(oError:subSystem)="C", oError:subSystem, "???")+"/"+;
			iif(ValType(oError:subCode)="N", sMake(oError:subCode), "???")+;
			" "+iif(ValType(oError:description)="C", oError:description, "")+;
			iif(!Empty(oError:operation), ": "+oError:operation, "")+;
			iif(!Empty(oError:filename), ": "+oError:filename, "")+;
			iif(!Empty(oError:osCode), " ("+sMake(oError:osCode)+")", "")+;
			" Callstack: "+CallStack()

STATIC FUNCTION CallStack()
   LOCAL nCtr := 3, cStack := ""
	WHILE !Empty(ProcName(++nCtr))
		cStack += "/"+ProcName(nCtr)+","+sMake(ProcLine(nCtr))
	ENDWHILE
	RETURN SubStr(cStack, 2)
ENDFUNCTION

/*
 1.02 02.05.93 Eliminated error recovery by returning logical instead of NIL
*/
