/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Returns the decimal portion of a number.
//
// Syntax:
//    mDecimal(<nAmount>) -> nDecimal
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    nAmount     Any amount
//
// Returns:
//    nDecimal    Decimal portion of number
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL nTest1 := 123.45, nTest2 := 1
//       ? mDecimal(nTest1)      /* 0.45 */
//       ? mDecimal(nTest2)      /* 0    */
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Returns the decimal portion of a number.
//
// Notes:
//    This function was not in the former commercial release.
//
// See Also:
//    mCents()
//    fDecimals()
//
// Category:
//    Math Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION mDecimals(nAmount)
   RETURN nAmount-Int(nAmount)
ENDFUNCTION
