/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Removes the specified subdirectory
//
// Syntax:
//    fRmDir(<cPath>) -> lSuccess
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    cPath       Path name
//
// Returns:
//    lSuccess    .y. if successful
//
// Examples:
//
//    FUNCTION TestIt()
//       LOCAL cPath := "\TESTIT", cCurDir := CurDir()
//       ? File(cPath+"\PRN")    /* false, does not exist         */
//       ? fMkDir(cPath)         /* true, created subdirectory    */
//       ? fChDir(cPath)         /* true, changed subdirectory    */
//       ? CurDir()              /* "TESTIT"                      */
//       ? File(cPath+"\PRN")    /* true, dir exists              */
//       fChDir("\"+cCurDir)     /* return to original directory  */
//       ? fRmDir(cPath)         /* true, removed subdirectory    */
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Removes the specified subdirectory if it is empty.
//
// See Also:
//    fMkDir()
//    fChDir()
//
// Category:
//    File Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION fRmDir(cPath)
   RETURN afRmDir(cPath)
ENDFUNCTION
