/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"
#include "fileio.ch"

////////////////
////////////////
//
// Purpose:
//    Reads a line from a text file
//
// Syntax:
//    fReadLine(<nFile>) -> cLine
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    nFile       File handle of text file
//
// Returns:
//    cLine       The line read
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL nTest
//       nTest := CreateText()
//       ? fReadLine(nTest)      /* "This is line 1." */
//       fClose(nTest)
//    ENDFUNCTION
//
//    #include "fileio.ch"
//    STATIC FUNCTION CreateText()
//       LOCAL nHandle := fCreate("testtest.txt")
//       fWriteLine(nHandle, "This is line 1.")
//       fWriteLine(nHandle, "This is line 2.")
//       fWriteLine(nHandle, "This is line 3.")
//       fSeek(nHandle, 0, FS_SET)     /* Set beginning of file */
//       RETURN nHandle
//    ENDFUNCTION
//
// Files:
//    (<nFile>)
//
// Description:
//    Reads the next line from a text file, positioning the byte pointer to
//    the next line, if any.  Returns "" if no lines left.
//
// See Also:
//    fWriteLine()
//
// Category:
//    File Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION fReadLine(nHandle)
   LOCAL cBuffer, cLine := "", nBytes, cTrueBuffer, cTemp
   cBuffer := Space(512)
   WHILE (nBytes := fRead(nHandle, @cBuffer, 512)) > 0
      cTrueBuffer := Left(cBuffer, nBytes)
      IF CR$cTrueBuffer
         cLine += (cTemp := Left(cTrueBuffer, At(CR, cTrueBuffer)-1))
         fSeek(nHandle, Len(cTemp)-nBytes+1, FS_RELATIVE)
         EXIT
      ENDIF
      cLine += cTrueBuffer
   ENDWHILE
   RETURN StrTran(cLine, LF)
ENDFUNCTION
