/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Returns the extension from a file name
//
// Syntax:
//    fExtName(<cFile>) -> cExt
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    cFile       File name
//
// Returns:
//    cExt        Extension
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL cTest := "Test.dbf"
//       ? cExtName(cTest)       /* "DBF" */
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Returns the extension name from a file name.  If no parameter is passed,
//    then the string "invalid" is returned, otherwise the returned string is
//    always uppercase and 3 characters, including spaces if necessary.
//
// See Also:
//    fExtension()
//    fExtNew()
//    fExtNone()
//
// Category:
//    File Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION fExtName(cFileName)
   LOCAL cExtension
   IF pCount()!=1
      RETURN "invalid"
   ENDIF
   IF !fExtension(cFileName)
      RETURN '   '
   ENDIF
   cExtension := SubStr(cFileName, rAt('.', cFileName)+1)
   RETURN Upper(sSetLength(cExtension, 3))
ENDFUNCTION
