/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Determines if all fields are empty
//
// Syntax:
//    fEmpty() -> lAllEmpty
//
// Formal Arguments: (0)
//
// Returns:
//    lAllEmpty      .y. if all fields are empty
//
// Examples:
//
// Files:
//    none
//
// Description:
//    This function returns .y. if all fields in the current record are empty.
//
// See Also:
//
// Category:
//    Field Function
//
// Revisions:
//    06/18/94 Added comment blocks
//
////////////////
////////////////

FUNCTION fEmpty()
   LOCAL nCtr, lEmpty := .y.
   FOR nCtr := 1 to fCount()
      IF !Empty(FieldGet(nCtr))
         lEmpty := .n.
         EXIT
      ENDIF
   NEXT
   RETURN lEmpty
ENDFUNCTION
