/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Returns the number of decimal portions from a number
//
// Syntax:
//    fDecimals(<nAmount>) -> nDecimals
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    nAmount     Any number
//
// Returns:
//    The number of decimal positions in a number.
//
// Notes:
//    This is corrected from released commercial version which would return
//    -1 if no decimal point was found.
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL nTest1 := 123.45, nTest2 := 1
//       ? fDecimals(nTest1)        /* 2 */
//       ? fDecimals(nTest2)        /* 0 */
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Returns the number of decimal positions in a number.
//
// See Also:
//    mDecimal()
//    mCents()
//
// Category:
//    File Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION fDecimals(nAmount)
   LOCAL cTemp
   cTemp := lTrim(Str(nAmount-Int(nAmount)))
   RETURN iif("."$cTemp, Len(cTemp)-2, 0)
ENDFUNCTION
