/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Does multiple computations with a single pass through a file
//
// Syntax:
//    fCompute(<aComp>, [<bFor>], [<bWhile>], [<nNext>], [<nRec>], [<lRest>])
//              -> aResults
//
// Formal Arguments: (6)
//    Name        Description
//    ___________ ____________
//    aComp       2-dimensional array or string, defined in description
//    bFor        FOR clause code block [{|| .y.}]
//    bWhile      WHILE clause code block [{|| .y.}]
//    nNext       NEXT clause, number of records to process [RecCount()]
//    nRec        RECORD clause, record number to process [NIL]
//    lRest       REST clause [NIL]
//
// Returns:
//    aResults
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL aResults
//       CreateTest()
//       aResults := fCompute({{"S", "Balance"},;
//                             {"A", "Balance", {||Balance>0}}})
//       aEval(aResults, {|aResult| qOut(aResult[1], aResult[2])})
//       /* results:  {{15125.71, 5}, {3781.43, 4}} */
//       CLOSE Test
//    ENDFUNCTION
//
//    #include "alias.ch"
//    STATIC FUNCTION CreateTest()
//       fCreateDbf("Test/Name/C/32/Balance/N/12/2/Date/D/Over21/L/Notes/M")
//       USE Test NEW EXCLUSIVE
//       ADDRECORD ALIAS Test
//       Test->Name    := "Abbott, Jake"
//       Test->Balance := 0.00
//       Test->Date    := CtoD("9/26/94")
//       Test->Over21  := .y.
//       Test->Notes   := ""
//       ADDRECORD ALIAS Test
//       Test->Name    := "Beckner, John Wm"
//       Test->Balance := 15000.00
//       Test->Date    := CtoD("9/26/94")
//       Test->Over21  := .y.
//       Test->Notes   := "These are notes!"
//       ADDRECORD ALIAS Test
//       Test->Name    := "Beckner, Elizabeth Anne"
//       Test->Balance := 0.58
//       Test->Date    := CtoD("12/18/96")
//       Test->Over21  := .n.
//       Test->Notes   := ""
//       ADDRECORD ALIAS Test
//       Test->Name    := "Beckner, Joseph Alan"
//       Test->Balance := 1.68
//       Test->Date    := CtoD("6/10/98")
//       Test->Over21  := .n.
//       Test->Notes   := "These are too!"
//       ADDRECORD ALIAS Test
//       Test->Name    := "Zumundi, Beavis"
//       Test->Balance := 123.45
//       Test->Date    := CtoD("")
//       Test->Over21  := .y.
//       Test->Notes   := ""
//       GO TOP
//    ENDFUNCTION
//
//
// Files:
//    none
//
// Description:
//    Full
//
// See Also:
//    x
//
// Category:
//    File Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION fCompute(aComputor, bFor, bWhile, nNext, nRec, lRest)

/*
   aComputor is a two-dimensional array.  The first element is the
   computational type:

   "A"   Average
   "S"   Sum

   The second element is the fieldname.  The third through the seventh elements
   are optional and are equivalent to the dbEval clauses of the same name.

   Example:

   fCompute(   {{"S", "Balance"};
               {"A", "Balance", {||Balance>0}}})

   This would return an array of {{nBalCnt, nBalSum}, {nBalCnt, nBalAvg}}

   OPTIONALLY, you can use the format of fCompute(cFile), where cFile is the
   fully qualified filename of the array data in the following format:

   S|A, <fieldname>, <block>
*/

   LOCAL aReturn := {}, nLen, aTemp
   IF ValType(aComputor)="C"
      aTemp     := aRead(aComputor)
      aComputor := {}
      aEval(aTemp, {|cLine, nCtr| iif(Empty(cLine), aTemp[nCtr] := NIL,)})
      aPack(aTemp)
      aEval(aTemp, {|cLine| aAdd(aComputor, {sParse(@cLine, "//"),;
            sParse(@cLine, "//"), &(cLine)})})
   ENDIF
   aSize(aReturn, nLen := Len(aComputor))
   aEval(aReturn, {|a, nCtr| aReturn[nCtr] := {0, 0}})
   aEval(aComputor, {|a| iif(Len(a)=2, aSize(a, 3),),;
         iif(a[3]=NIL, a[3] := {||.y.},)})
   dbEval({||aEval(aReturn, {|a, nCtr| iif(Eval(aComputor[nCtr, 3]),;
         Eval({|a, nCtr| a[1] += &(lTrim(aComputor[nCtr, 2])),;
   a[2]++}, a, nCtr),)})}, bFor, bWhile, nNext, nRec, lRest)
   aEval(aReturn, {|a, nCtr| iif(Upper(aComputor[nCtr, 1])="A",;
         a[1] /= a[2],)})
   RETURN aReturn
ENDFUNCTION
