/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Returns the year of a date as a 2-digit number
//
// Syntax:
//    dYear2([<dAny>]) -> nYear
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    dAny        Any date
//
// Returns:
//    nYear       2-digit year
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL dTest := CtoD("9/26/59")
//       ? dYear2(dTest)         /* 59 */
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Similar to Year(), which returns a 4-digit year, this function returns
//    a 2-digit year.
//
// Category:
//    Date Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION dYear2(dAny)
   DEFAULT dAny TO Date()
   RETURN Val(Right(Str(Year(dAny), 4), 2))
ENDFUNCTION
