/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Returns a date converted from a compressed format with dSave()
//
// Syntax:
//    dRestore(<cCompressed>) -> dUncompress
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    cCompressed Compressed date from dSave()
//
// Returns:
//    dUncompress The uncompressed date
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL dTest := CtoD("9/26/96"), cCompressed
//       cCompressed := dSave(dTest)
//       ? Len(cCompressed)         /* 3        */
//       ? dRestore(cCompressed)    /* 09/26/96 */
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Returns a date from a compressed string-date created by dSave().
//
// See Also:
//    dSave()
//
// Category:
//    Date Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION dRestore(cStored)
   RETURN ctod(sMake(Asc(sParse(@cStored, 1)))+"/"+;
         sMake(Asc(sParse(@cStored, 1)))+"/"+;
         sMake(Asc(cStored)))
ENDFUNCTION
