/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Converts a month and year into a valid date value
//
// Syntax:
//    dMMYY2Date(<nMonth>, <nYear>) -> dConvert
//
// Formal Arguments: (2)
//    Name        Description
//    ___________ ____________
//    nMonth      Month
//    nYear       Year
//
// Returns:
//    dConvert    Date
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL nTestMM := 9, nTestYY := 98
//       ? dMMYY2Date(nTestMM, nTestYY)      /* 09/01/98 */
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Returns a date converted from a passed month and year.  The returned
//    date is the first day of the month.
//
// Category:
//    Date Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION dMMYY2Date(nMM, nYY)
   RETURN CtoD(sMake(nMM)+"/1/"+sMake(nYY))
ENDFUNCTION
