/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"
#include "set.ch"

////////////////
////////////////
//
// Purpose:
//    Returns the number of days in the month
//
// Syntax:
//    dDaysInMonth(<nMonth>, [<nYear>]) -> nDays
//    dDaysInMonth(<dAny>)              -> nDays
//
// Formal Arguments: (3)
//    Name        Description
//    ___________ ____________
//    nMonth      Month number, 1-12
//    nYear       Year [NIL]
//    dAny        Any date
//
// Returns:
//    nDays       Number of days in the month
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL dTest := CtoD("2/1/96")
//       LOCAL nMonth := 2, nYear := 1996
//       ? dDaysInMonth(dTest)         /* 29 */
//       ? dDaysInMonth(nMonth, nYear) /* 29 */
//       ? dDaysInMonth(nMonth)        /* 28 */
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Returns the number of days in the specified month.  For months other
//    than February, you can specify either the month number or a date within
//    the month.  However, for February to accurately determine the leap day,
//    you must specify either the month and year or a date value.  See the
//    example.
//
// See Also:
//
// Category:
//    Date Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION dDaysInMonth(nMonth, nYear)
   IF ValType(nMonth)="D"
      IF Str(Month(nMonth),2)$' 1, 3, 5, 7, 8,10,12'
         RETURN 31
      ELSEIF Str(Month(nMonth),2)$' 4, 6, 9,11'
         RETURN 30
      ELSEIF !Empty(CtoD('2/29/'+Str(Year(nMonth)-Set(_SET_EPOCH),2)))
         RETURN 29
      ELSE
         RETURN 28
      ENDIF
   ENDIF
   IF Str(nMonth,2)$' 1, 3, 5, 7, 8,10,12'
      RETURN 31
   ELSEIF Str(nMonth,2)$' 4, 6, 9,11'
      RETURN 30
   ELSEIF nYear=NIL .or.;
         Empty(CtoD('2/29/'+Str(Year(Date())-Set(_SET_EPOCH),2)))
      RETURN 28
   ELSE
      RETURN 29
   ENDIF
   RETURN 0
ENDFUNCTION
