/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Returns the date of the beginning of the year
//
// Syntax:
//    dBegYear([<dTest>]) -> dBeginning
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    dTest       Any date
//
// Returns:
//    dBeginning  First date in year in which dTest is in
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL dAny := CtoD("9/26/98")
//       ? dBegYear(dAny)             /* 01/01/98 */
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Returns the first date of the year specified in <dTest>.
//
// See Also:
//    dEndYear()
//    dBegQuarter()
//    dEndQuarter()
//    dBegMonth()
//    dEndMonth()
//    dDaysLeftY()
//    dDaysGoneY()
//
// Category:
//    Date Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION dBegYear(dAny)
   RETURN CtoD("1.1."+Right(DtoC(iif(dAny=NIL, Date(), dAny)), 2))
ENDFUNCTION
