/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990, 1991, 1992 BecknerVision Inc - All Rights Reserved

    Written by John Wm Beckner        THIS NOTICE MUST NOT BE REMOVED
    BecknerVision Inc
    PO Box 11945                      SOURCE CODE (THIS FILE) MAY NOT BE
    Winston-Salem NC 27116            DISTRIBUTED!  ONLY REGISTERED USERS
    Fax: 919/760-1003                 OF BECKNER LIBRARY & UTILITIES II MAY
                                      BE IN POSSESSION OF THIS FILE.
*/

#include "beckner.inc"

/* NOTE: THIS CODE HAS NOT BEEN OPTIMIZED TO BECKNERVISION'S CURRENT STANDARD */

MEMVAR vd_string, vdTemplate, lUseColor, temprow, tempcol, vdhandle
MEMVAR field_def,no_fields,x,xchar,use_array,y,tparm,stype, pbrow, pbcol
MEMVAR fld_pix, fld_row, fld_col, fld_data, fld_type, GetList, scr, go_on
MEMVAR ptrow, ptcol, lOldColor, sendback, temp, tr, tc, br, bc, usefldnms
MEMVAR temptem, tru_row, tru_col, realthing, fld_name, xscreen, clr, aa
MEMVAR a, tcurs, ptr, curspos, zscreen, xx, r1, r2, curcurs, opt, boxchars
MEMVAR base_row, base_col, cur_row, cur_col, holdarea, loopit, twindow, ctr
MEMVAR foundit, max_width, fname, ftype, fpix, gc, msg, really, ytoaccept
MEMVAR tarray, trow, tcol, ttype, tpix, number, acurs, pix, abox, st
MEMVAR no_rows, no_cols, tempcurs, tchar, ttrow, ttcol

FUNCTION BecknerV(p1, p2, p3)
   LOCAL cOldColor
   priv vd_string,vdtemplate, lUseColor
   vd_string := p1
   vdtemplate := p2
   lusecolor := p3
   priv field_def,no_fields,x,xchar,use_array,y,tparm,stype
   DEFAULT lUseColor TO IsColor()
   if lUseColor
      lOldColor := SetColor("b/w,w/b,,,b/w")
   endi
   if type('vdtemplate')='A'
      use_array=.y.
   else
      use_array=.n.
   endi
   for y=1 to if(use_array,len(vdtemplate),1)
      if !left(if(use_array,vdtemplate[y],vdtemplate),1)$chr(255)+chr(251)+chr(252)
         if lUseColor
            SetColor(lOldColor)
         endi
         retu '-1'
      endi
      stype=asc(left(if(use_array,vdtemplate[y],vdtemplate),1))
      if use_array
         tparm=vd_string[y]
         vd_string[y]=''
      else
         tparm=vd_string
         vd_string=''
      endi
      field_def=BecknerVDS(if(use_array,vdtemplate[y],vdtemplate))
      ptrow=val(sParse(@field_def,chr(254)))
      ptcol=val(sParse(@field_def,chr(254)))
      pbrow=val(sParse(@field_def,chr(254)))
      pbcol=val(sParse(@field_def,chr(254)))
      no_fields=round(sCount(chr(254),field_def)/4,0)
      decl fld_type[no_fields],fld_data[no_fields],fld_row[no_fields],fld_col[no_fields],fld_pix[no_fields]
      for x=1 to no_fields
         fld_type[x]=sParse(@field_def,chr(254))
         fld_pix[x]=sParse(@field_def,chr(254))
         fld_row[x]=val(sParse(@field_def,chr(254)))
         fld_col[x]=val(sParse(@field_def,chr(254)))
      next
      do whil .y.
         if empty(tparm)
            for x=1 to no_fields
               fld_data[x]=if(fld_type[x]='C',space(len(fld_pix[x])),if(fld_type[x]='D',dEmpty(),if(fld_type[x]='L',.n.,val(transform(0,fld_pix[x])))))
            next
         else
            for x=1 to no_fields
               xchar=sParse(@tparm,chr(254))
               fld_data[x]=if(fld_type[x]='C',xchar,if(fld_type[x]='D',ctod(xchar),if(fld_type[x]='L',if(xchar='Y',.y.,.n.),val(xchar))))
               if fld_type[x]='C'
                  if len(xchar)<len(fld_pix[x])
                     fld_data[x]=fld_data[x]+space(len(fld_pix[x])-len(xchar))
                  endi
               endi
            next
         endi
         for x=1 to no_fields
            @ fld_row[x],fld_col[x] get fld_data[x] pict fld_pix[x]
         next
         read
         for x=1 to no_fields
            if use_array
               vd_string[y]=vd_string[y]+if(fld_type[x]='C',trim(fld_data[x]),if(fld_type[x]='D',dtoc(fld_data[x]),if(fld_type[x]='L',if(fld_data[x],'Y','N'),ltrim(str(fld_data[x])))))+chr(254)
            else
               vd_string=vd_string+if(fld_type[x]='C',trim(fld_data[x]),if(fld_type[x]='D',dtoc(fld_data[x]),if(fld_type[x]='L',if(fld_data[x],'Y','N'),ltrim(str(fld_data[x])))))+chr(254)
            endi
         next
         if lastkey()=23
            exit
         elseif lastkey()=18.and.x>1
            x=x-2
         elseif empty(tparm)
            scr=savescreen(24,0,24,79)
            @ 24,0
            go_on=.n.
            @ 24,0 say 'Another screen (Y/N)?' get go_on pict 'Y'
            read
            restscreen(24,0,24,79,scr)
            if !go_on
               exit
            endi
         endi
      endd
   next
   poscr(ptrow,ptcol,pbrow,pbcol,stype)
   if lUseColor
      SetColor(lOldColor)
   endi
   retu if(use_array,'array',vd_string)
ENDFUNCTION

FUNCTION BecknerVDS(p1)
   priv vdtemplate := p1
   priv sendback,temp,tr,tc,br,bc
   sendback=substr(vdtemplate,2,at(chr(25),vdtemplate)-1)
   temp=substr(vdtemplate,2)
   tr=val(sParse(@temp,chr(254)))
   tc=val(sParse(@temp,chr(254)))
   br=val(sParse(@temp,chr(254)))
   bc=val(sParse(@temp,chr(254)))
   puscr(tr,tc,br,bc,255)
   temp=substr(temp,at(chr(25),temp)+1)
   SetPos(tr,tc)
   do whil !empty(temp)
      ?? sParse(@temp,chr(141))
      SetPos(row()+1,tc)
   endd
   SetPos(tr,tc)
   retu sendback
ENDFUNCTION

FUNCTION BecknerVED(p1, p2, p3)
   priv vdtemplate,usefldnms,lUseColor
   vdtemplate := p1
   usefldnms := p2
   lusecolor := p3
   if pcount()=0
      retu ''
   endi
   DEFAULT UseFldNms TO .n.
   priv field_def,ts,tc,br,bc,xscreen,clr,x,z,tline,zscreen,temptem,stype,tru_row,tru_col,temp,aa,realthing
   temptem=vdtemplate
   stor 0 to tru_row,tru_col
   realthing=.n.
   decl fld_type[100],fld_data[100],fld_row[100],fld_col[100],fld_pix[100]
   if usefldnms
      decl fld_name[100]
   endi
   xscreen=vSaveIt()
   clr=setcolor()
   *set colo to n+/w
   CLS
   vBackground()
   if !empty(vdtemplate)
      stype=asc(left(vdtemplate,1))
      field_def=BecknerVDS(vdtemplate)
      if stype<251
         temp=sParse(@field_def,chr(254))
         do whil !empty(temp)
            aa=sParse(@temp,'/')
            do case
            case aa='R'
               tru_row=val(substr(aa,2))
            case aa='C'
               tru_col=val(substr(aa,2))
            case aa='W'
               realthing=.y.
            endc
         endd
      endi
      ptrow=val(sParse(@field_def,chr(254)))
      ptcol=val(sParse(@field_def,chr(254)))
      pbrow=val(sParse(@field_def,chr(254)))
      pbcol=val(sParse(@field_def,chr(254)))
      no_fields=round(sCount(chr(254),field_def)/4,0)
      for x=1 to no_fields
         if usefldnms
            fld_name[x]=sParse(@field_def,chr(254))
         endi
         fld_type[x]=sParse(@field_def,chr(254))
         fld_pix[x]=sParse(@field_def,chr(254))
         fld_row[x]=val(sParse(@field_def,chr(254)))
         fld_col[x]=val(sParse(@field_def,chr(254)))
      next
   else
      stype=255
      ptrow=12
      ptcol=39
      pbrow=12
      pbcol=39
      field_def=''
      no_fields=0
      puscr(ptrow,ptcol,pbrow,pbcol,stype)
   endi
   *set colo to n/gr
   if pbrow<23
      @ 23,0 clea to 24,79
      @ 24,50 say '(press <alt-letter> for menu)'
   endi
   if ptrow>1
      @ 0,0 clea to 1,79
      a='Beckner VariData Editor v2.0'
      @ 0,vCenterPos(a) say a
      *set colo to w/b
      @ 1,10 say 'Window'
      @ 1,30 say 'Fields'
      @ 1,50 say 'Abort'
      @ 1,70 say 'Exit'
   endi
   *set colo to w/b
   set key 28 to vd_help
   if tru_row=0
      tru_row=pbrow-ptrow+1
   endi
   if tru_col=0
      tru_col=pbcol-ptcol+1
   endi
   SetPos(ptrow,ptcol)
   do whil .y.
      tcurs=vCursSave()
      temprow=row()
      tempcol=col()
      if pbrow<if(realthing,wndheight(vdhandle),MaxRow())-2
         @ 24,10
         if vReadChar(temprow,tempcol)=chr(4)
            ptr=jwb_afind(temprow,tempcol)
            if ptr>0
               @ 24,10 say '#'+ltrim(str(ptr))
               @ 24,col()+1 say if(usefldnms,fld_name[ptr],'')
               @ 24,col()+1 say fld_type[ptr]
               @ 24,col()+1 say fld_pix[ptr]
            endi
         endi
         @ 24,72 say pbcol-tempcol+1 pict '99'
         @ 24,75 say temprow pict '99'
         @ 24,78 say tempcol pict '99'
      endi
      vCursRest(tcurs)
      IF lUseColor
         vNewColor(row(),ptcol,row(),pbcol,'w+/n')
         vNewColor(ptrow,col(),pbrow,col(),'w+/n')
         vNewColor(1,10,1,10,'b/g')
         vNewColor(1,30,1,30,'b/g')
         vNewColor(1,50,1,50,'b/g')
         vNewColor(1,70,1,70,'b/g')
      ENDIF
      x=inkey(60)
      if x=0
         sndwakeup()
         x=inkey(60)
         if x=0
            curspos=vCursSave()
            zscreen=vSaveIt()
            *set colo to g/n
            set curs off
            clea
            do whil .y.
               r1=pRandom(25)-1
               r2=pRandom(56)-1
               @ r1,r2 say 'Press any key to continue'
               iif(lUseColor, vNewColor(r1,r2,r1,r2+24,ltrim(str(pRandom(7)+1))+'/n'),)
               xx=inkey(.5)
               if xx>0
                  exit
               endi
               xx=inkey(.3)
               @ r1,r2 say space(25)
               if xx>0
                  exit
               endi
            endd
            set curs on
            *set colo to w/b
            vRestore(zscreen)
            rele zscreen,r1,r2
            vCursRest(curspos)
         endi
      endi
      if x=0
         loop
      endi
      IF lUseColor
         vNewColor(row(),ptcol,row(),pbcol,'w/b')
         vNewColor(ptrow,col(),pbrow,col(),'w/b')
      ENDIF
      curcurs=vCursSave()
      do case
      case x=273                                 && window option
         vSaveIt(2,9,12,30)
         vBorder(2,9,12,30)
         IF lUseColor
            vNewColor(1,10,1,10,'w/b')
            vNewColor(1,30,1,30,'w/b')
            vNewColor(1,50,1,50,'w/b')
            vNewColor(1,70,1,70,'w/b')
         ENDIF
         @ 3,10 say 'Expand window'
         @ 4,10 say 'Shrink window'
         @ 5,10 say 'Insert row/column'
         @ 6,10 say 'Delete row/column'
         @ 7,10 say 'Middle of screen'
         @ 8,10 say 'Position'
         @ 9,10 say 'Borders'
         @ 10,10 say 'Clear BG'
         @ 11,10 say 'Lines & Boxes'
         IF lUseColor
            vNewColor(3,10,3,10,'b/g')
            vNewColor(4,10,4,10,'b/g')
            vNewColor(5,10,5,10,'b/g')
            vNewColor(6,10,6,10,'b/g')
            vNewColor(7,10,7,10,'b/g')
            vNewColor(8,10,8,10,'b/g')
            vNewColor(9,10,9,10,'b/g')
            vNewColor(10,10,10,10,'b/g')
            vNewColor(11,10,11,10,'b/g')
         ENDIF
         opt=' '
         do whil !opt$'ESIDMPBCL'+chr(27)
            opt=upper(chr(inkey(0)))
         endd
         vRestore()
         tr=ptrow
         tc=ptcol
         vCursRest(curcurs)
         do case
         case opt=chr(27)
            pSoundError()
            loop
         case opt='L'
            if vReadChar()=' '
               pSoundError()
               loop
            endi
            vSaveIt(2,9,9,40)
            vBorder(2,9,9,40)
            @ 3,10 say '1/Double lined'
            @ 4,10 say '2/Single lined'
            @ 5,10 say '3/Top-Bottom Single'
            @ 6,10 say '4/Top-Bottom Double'
            @ 7,10 say '5/Frame character'
            @ 8,10 say '6/User defined'
            IF lUseColor
               vNewColor(3,10,3,10,'b/g')
               vNewColor(4,10,4,10,'b/g')
               vNewColor(5,10,5,10,'b/g')
               vNewColor(6,10,6,10,'b/g')
               vNewColor(7,10,7,10,'b/g')
               vNewColor(8,10,8,10,'b/g')
            ENDIF
            opt=' '
            do whil !opt$'12345'+chr(27)
               opt=chr(inkey(0))
            endd
            vRestore()
            vCursRest(curcurs)
            do case
            case opt=chr(27)
               loop
            case opt='1'
               boxchars=sChrData({201,205,187,186,188,205,200,186})
            case opt='2'
               boxchars=sChrData({218,186,191,179,217,196,192,179})
            case opt='3'
               boxchars=sChrData({214,196,183,186,189,196,211,186})
            case opt='4'
               boxchars=sChrData({213,205,184,179,190,205,212,179})
            case opt='5'
               boxchars=chr(177)
            endc
            aa='Arrows to move, <ESC> when done, A/bort'
            @ 24,10
            @ 24,vCenterPos(aa) say aa
            vCursRest(curcurs)
            stor row() to base_row,cur_row
            stor col() to base_col,cur_col
            holdarea=vSaveIt(base_row,base_col,cur_row,cur_col)
            do whil .y.
               x=inkey(0)
               do case
               case upper(chr(x))='A'
                  vRestore(holdarea)
                  vCursRest(curcurs)
                  exit
               case x=24
                  tempcurs=vCursSave()
                  if cur_row=pbrow
                     pSoundError()
                     loop
                  endi
                  cur_row=cur_row+1
                  if vReadChar(cur_row,base_col)!=' '
                     pSoundError()
                     loop
                  endi
                  loopit=.n.
                  do whil vReadChar(cur_row,cur_col)!=' '
                     do whil vReadChar(cur_row,cur_col)!=' '
                        cur_col=cur_col+1
                        if cur_col>pbcol
                           loopit=.y.
                           exit
                        endi
                     endd
                     if loopit
                        exit
                     endi
                     cur_row=cur_row+1
                     if cur_row>pbrow
                        loopit=.y.
                        exit
                     endi
                     if vReadChar(cur_row,base_col)!=' '
                        loopit=.y.
                        exit
                     endi
                  endd
                  if loopit
                     pSoundError()
                     vCursRest(tempcurs)
                     cur_row=row()
                     cur_col=col()
                     loop
                  endi
                  vRestore(holdarea)
               endc
               holdarea=vSaveIt(base_row,base_col,cur_row,cur_col)
               @ base_row,base_col,cur_row,cur_col box boxchars
            endd
         case opt='B'
            tcurs=vCursSave()
            vSaveIt(2,9,6,30)
            vBorder(2,9,6,30)
            @ 3,10 say '1/Border & Shadow'
            @ 4,10 say '2/No shadow'
            @ 5,10 say '3/Neither'
            opt=' '
            do whil !opt$'123'+chr(27)
               opt=chr(inkey(0))
            endd
            vRestore()
            holdarea=vSaveIt(ptrow,ptcol,pbrow,pbcol)
            poscr(ptrow,ptcol,pbrow,pbcol,stype)
            if opt='1'
               stype=255
            elseif opt='2'
               stype=251
            elseif opt='3'
               stype=252
            endi
            puscr(ptrow,ptcol,pbrow,pbcol,stype)
            vRestore(holdarea)
            vCursRest(tcurs)
            loop
         case opt='C'
            tcurs=vCursSave()
            puscr(ptrow,ptcol,pbrow,pbcol,stype)
            clea
            poscr(ptrow,ptcol,pbrow,pbcol,stype)
            vCursRest(tcurs)
            loop
         case opt='P'
            tcurs=vCursSave()
            aa='Use arrow keys to move window, <ESC> when done'
            @ 24,10
            @ 24,vCenterPos(aa) say aa
            vCursRest(tcurs)
            do whil .y.
               x=inkey()
               do case
               case x=0
                  loop
               case x=4
                  if pbcol=78
                     pSoundError()
                     loop
                  endi
                  twindow=vSaveIt(ptrow,ptcol,pbrow,pbcol)
                  vBorder(ptrow,ptcol,pbrow,pbcol)
                  poscr(ptrow,ptcol,pbrow,pbcol,stype)
                  pbcol=pbcol+1
                  ptcol=ptcol+1
                  puscr(ptrow,ptcol,pbrow,pbcol,stype)
                  vRestore(twindow)
                  rele twindow,ctr
                  loop
               case x=19
                  if ptcol=if(stype=252,0,1)
                     pSoundError()
                     loop
                  endi
                  twindow=vSaveIt(ptrow,ptcol,pbrow,pbcol)
                  vBorder(ptrow,ptcol,pbrow,pbcol)
                  poscr(ptrow,ptcol,pbrow,pbcol,stype)
                  pbcol=pbcol-1
                  ptcol=ptcol-1
                  puscr(ptrow,ptcol,pbrow,pbcol,stype)
                  vRestore(twindow)
                  rele twindow,ctr
                  loop
               case x=5
                  if ptrow=if(stype=252,0,1)
                     pSoundError()
                     loop
                  endi
                  twindow=vSaveIt(ptrow,ptcol,pbrow,pbcol)
                  vBorder(ptrow,ptcol,pbrow,pbcol)
                  poscr(ptrow,ptcol,pbrow,pbcol,stype)
                  pbrow=pbrow-1
                  ptrow=ptrow-1
                  puscr(ptrow,ptcol,pbrow,pbcol,stype)
                  vRestore(twindow)
                  rele twindow,ctr
                  loop
               case x=24
                  if pbrow=23
                     pSoundError()
                     loop
                  endi
                  twindow=vSaveIt(ptrow,ptcol,pbrow,pbcol)
                  vBorder(ptrow,ptcol,pbrow,pbcol)
                  poscr(ptrow,ptcol,pbrow,pbcol,stype)
                  pbrow=pbrow+1
                  ptrow=ptrow+1
                  puscr(ptrow,ptcol,pbrow,pbcol,stype)
                  vRestore(twindow)
                  rele twindow,ctr
                  loop
               case x=27
                  exit
               endc
            endd
         case opt='E'
            aa='Use arrow keys to expand window, <ESC> when done'
            @ 24,10
            @ 24,vCenterPos(aa) say aa
            do whil .y.
               x=inkey()
               if x=0
                  loop
               endi
               do case
               case x=4
                  if pbcol=77
                     pSoundError()
                     loop
                  endi
                  twindow=strtran(GetEm(ptrow,ptcol,pbrow,pbcol),chr(141),chr(254))
                  twindow=strtran(twindow,chr(141),chr(254))
                  poscr(ptrow,ptcol,pbrow,pbcol,stype)
                  pbcol=pbcol+1
                  puscr(ptrow,ptcol,pbrow,pbcol,stype)
                  ctr=0
                  do whil !empty(twindow)
                     @ ptrow+ctr,ptcol say sParse(@twindow,chr(254))
                     ctr=ctr+1
                  endd
                  rele twindow,ctr
                  loop
               case x=19
                  if ptcol=1
                     pSoundError()
                     loop
                  endi
                  twindow=strtran(GetEm(ptrow,ptcol,pbrow,pbcol),chr(141),chr(254))
                  poscr(ptrow,ptcol,pbrow,pbcol,stype)
                  ptcol=ptcol-1
                  puscr(ptrow,ptcol,pbrow,pbcol,stype)
                  ctr=0
                  do whil !empty(twindow)
                     @ ptrow+ctr,ptcol say sParse(@twindow,chr(254))
                     ctr=ctr+1
                  endd
                  rele twindow,ctr
                  loop
               case x=5
                  if ptrow=3
                     pSoundError()
                     loop
                  endi
                  twindow=strtran(GetEm(ptrow,ptcol,pbrow,pbcol),chr(141),chr(254))
                  poscr(ptrow,ptcol,pbrow,pbcol,stype)
                  ptrow=ptrow-1
                  puscr(ptrow,ptcol,pbrow,pbcol,stype)
                  ctr=0
                  do whil !empty(twindow)
                     @ ptrow+ctr,ptcol say sParse(@twindow,chr(254))
                     ctr=ctr+1
                  endd
                  rele twindow,ctr
                  loop
               case x=24
                  if pbrow=20
                     pSoundError()
                     loop
                  endi
                  twindow=strtran(GetEm(ptrow,ptcol,pbrow,pbcol),chr(141),chr(254))
                  poscr(ptrow,ptcol,pbrow,pbcol,stype)
                  pbrow=pbrow+1
                  puscr(ptrow,ptcol,pbrow,pbcol,stype)
                  ctr=0
                  do whil !empty(twindow)
                     @ ptrow+ctr,ptcol say sParse(@twindow,chr(254))
                     ctr=ctr+1
                  endd
                  rele twindow,ctr
                  loop
               case x=27
                  exit
               endc
               pSoundError()
            endd
            SetPos(ptrow,ptcol)
            rele zscreen
         case opt='S'
            aa='Use arrow keys to shrink window, <ESC> when done'
            @ 24,10
            @ 24,vCenterPos(aa) say aa
            do whil .y.
               x=inkey()
               if x=0
                  loop
               endi
               do case
               case x=4
                  if ptcol=pbcol
                     pSoundError()
                     loop
                  endi
                  if !empty(strtran(GetEm(ptrow+1,pbcol+1,pbrow-1,pbcol-1),chr(141)))
                     if !warning('Do you wish to zap the characters in the last column (Y/N)?')
                        loop
                     endi
                  endi
                  twindow=strtran(GetEm(ptrow,ptcol,pbrow,pbcol-1),chr(141),chr(254))
                  poscr(ptrow,ptcol,pbrow,pbcol,stype)
                  ptcol=ptcol+1
                  puscr(ptrow,ptcol,pbrow,pbcol,stype)
                  ctr=0
                  do whil !empty(twindow)
                     @ ptrow+ctr,ptcol say sParse(@twindow,chr(254))
                     ctr=ctr+1
                  endd
                  rele twindow,ctr
                  loop
               case x=19
                  if ptcol=pbcol
                     pSoundError()
                     loop
                  endi
                  if !empty(strtran(GetEm(ptrow+1,pbcol+1,pbrow-1,pbcol-1),chr(141)))
                     if !warning('Do you wish to zap the characters in the last column (Y/N)?')
                        loop
                     endi
                  endi
                  twindow=strtran(GetEm(ptrow,ptcol,pbrow,pbcol-1),chr(141),chr(254))
                  poscr(ptrow,ptcol,pbrow,pbcol,stype)
                  pbcol=pbcol-1
                  puscr(ptrow,ptcol,pbrow,pbcol,stype)
                  ctr=0
                  do whil !empty(twindow)
                     @ ptrow+ctr,ptcol say sParse(@twindow,chr(254))
                     ctr=ctr+1
                  endd
                  rele twindow,ctr
                  loop
               case x=5
                  if ptrow=pbrow
                     pSoundError()
                     loop
                  endi
                  if !empty(strtran(GetEm(pbrow+1,ptcol+1,pbrow-1,pbcol-1),chr(141)))
                     if !warning('Do you wish to zap the characters in the last row (Y/N)?')
                        loop
                     endi
                  endi
                  twindow=strtran(GetEm(ptrow,ptcol,pbrow-1,pbcol),chr(141),chr(254))
                  poscr(ptrow,ptcol,pbrow,pbcol,stype)
                  pbrow=pbrow-1
                  puscr(ptrow,ptcol,pbrow,pbcol,stype)
                  ctr=0
                  do whil !empty(twindow)
                     @ ptrow+ctr,ptcol say sParse(@twindow,chr(254))
                     ctr=ctr+1
                  endd
                  rele twindow,ctr
                  loop
               case x=24
                  if pbrow=ptrow
                     pSoundError()
                     loop
                  endi
                  if !empty(strtran(GetEm(pbrow+1,pbcol+1,pbrow-1,pbcol-1),chr(141)))
                     if !warning('Do you wish to zap the characters in the last column (Y/N)?')
                        loop
                     endi
                  endi
                  twindow=strtran(GetEm(ptrow,ptcol,pbrow-1,pbcol),chr(141),chr(254))
                  poscr(ptrow,ptcol,pbrow,pbcol,stype)
                  ptrow=ptrow+1
                  puscr(ptrow,ptcol,pbrow,pbcol,stype)
                  ctr=0
                  do whil !empty(twindow)
                     @ ptrow+ctr,ptcol say sParse(@twindow,chr(254))
                     ctr=ctr+1
                  endd
                  rele twindow,ctr
                  loop
               case x=27
                  exit
               endc
            endd
            SetPos(ptrow,ptcol)
            rele zscreen
         case opt='D'
            aa='R/ow, C/olumn or A/bort?'
            vSaveIt(10,vCenterPos(aa)-1,12,vCenterPos(aa)+len(aa))
            vBorder(10,vCenterPos(aa)-1,12,vCenterPos(aa)+len(aa))
            iif(lUseColor, vNewColor(10,vCenterPos(aa)-1,12,vCenterPos(aa)+len(aa),'gr+/g'),)
            @ 11,vCenterPos(aa) say aa
            do whil .y.
               a=upper(chr(inkey(0)))
               if a$'RCA'
                  exit
               endi
            endd
            vRestore()
            vCursRest(curcurs)
            if a='C'
               if !empty(strtran(GetEm(ptrow,col(),pbrow,col()),chr(141)))
                  pSoundError()
                  loop
               endi
               vscroll(ptrow,col(),pbrow,pbcol,'l',1)
               for xx=1 to no_fields
                  if fld_col[xx]>col()
                     fld_col[xx]=fld_col[xx]-1
                  endi
               next
            elseif a='R'
               if !empty(strtran(GetEm(row(),ptcol,row(),pbcol),chr(141)))
                  pSoundError()
                  loop
               endi
               vscroll(row(),ptcol,pbrow,pbcol,'u',1)
               for xx=1 to no_fields
                  if fld_row[xx]>row()
                     fld_row[xx]=fld_row[xx]-1
                  endi
               next
            endi
         case opt='M'
            twindow=vSaveIt(ptrow,ptcol,pbrow,pbcol)
            vBorder(ptrow,ptcol,pbrow,pbcol)
            poscr(ptrow,ptcol,pbrow,pbcol,stype)
            no_rows=pbrow-ptrow+1
            no_cols=pbcol-ptcol+1
            ptrow=12-int(no_rows/2)
            pbrow=no_rows-1+ptrow
            ptcol=39-int(no_cols/2)
            pbcol=no_cols-1+ptcol
            puscr(ptrow,ptcol,pbrow,pbcol,stype)
            vRestore()
            SetPos(ptrow,ptcol)
         case opt='I'
            aa='R/ow, C/olumn or A/bort?'
            vSaveIt(10,vCenterPos(aa)-1,12,vCenterPos(aa)+len(aa))
            vBorder(10,vCenterPos(aa)-1,12,vCenterPos(aa)+len(aa))
            iif(lUseColor, vNewColor(10,vCenterPos(aa)-1,12,vCenterPos(aa)+len(aa),'gr+/g'),)
            @ 11,vCenterPos(aa) say aa
            do whil .y.
               a=upper(chr(inkey(0)))
               if a$'RCA'
                  exit
               endi
            endd
            vRestore()
            vCursRest(curcurs)
            if a='C'
               if !empty(strtran(GetEm(ptrow,pbcol,pbrow,pbcol),chr(141)))
                  pSoundError()
                  loop
               endi
               vscroll(ptrow,col(),pbrow,pbcol,'r',1)
               for xx=1 to no_fields
                  if fld_col[xx]>=col()
                     fld_col[xx]=fld_col[xx]+1
                  endi
               next
            elseif a='R'
               if !empty(GetEm(pbrow,ptcol,pbrow,pbcol))
                  pSoundError()
                  loop
               endi
               vscroll(row(),ptcol,pbrow,pbcol,'d',1)
               for xx=1 to no_fields
                  if fld_row[xx]>=row()
                     fld_row[xx]=fld_row[xx]+1
                  endi
               next
            endi
         endc
         tr=ptrow-tr
         tc=ptcol-tc
         for x=1 to no_fields
            fld_row[x]=fld_row[x]+tr
            fld_col[x]=fld_col[x]+tc
         next
      case x>31.and.x<250
         if vReadChar()=chr(4)
            pSoundError()
            loop
         endi
         @ row(),col() say chr(x)
         if col()>pbcol
            if row()=pbrow
               tone(2000,3)
               SetPos(ptrow,ptcol)
            else
               tone(2000,3)
               SetPos(row()+1,ptcol)
            endi
         endi
      case x=13                                  && enter key
         if pbrow=row()
            tone(2000,3)
            SetPos(ptrow,ptcol)
         else
            SetPos(row()+1,ptcol)
         endi
      case x=1                                   && home key
         SetPos(row(),ptcol)
      case x=6                                   && end key
         SetPos(row(),pbcol)
         if vReadChar()=chr(4)
            do whil vReadChar()=chr(4)
               SetPos(row(),col()-1)
            endd
            SetPos(row(),col()+1)
         endi
      case x=18                                  && pgup
         SetPos(ptrow,col())
         if vReadChar()=chr(4)
            do whil vReadChar()=chr(4)
               SetPos(row(),col()-1)
            endd
            SetPos(row(),col()+1)
         endi
      case x=3                                   && pgdn
         SetPos(pbrow,col())
         if vReadChar()=chr(4)
            do whil vReadChar()=chr(4)
               SetPos(row(),col()-1)
            endd
            SetPos(row(),col()+1)
         endi
      case x=19                                  && left arrow
         if col()=ptcol
            if row()=ptrow
               tone(2000,3)
               SetPos(pbrow,pbcol)
            else
               tone(2000,3)
               SetPos(row()-1,pbcol)
            endi
         else
            SetPos(row(),col()-1)
         endi
         if vReadChar()=chr(4)
            do whil vReadChar()=chr(4)
               SetPos(row(),col()-1)
            endd
            SetPos(row(),col()+1)
         endi
      case x=4                                   && right arrow
         if vReadChar()=chr(4)
            do whil vReadChar()=chr(4)
               SetPos(row(),col()+1)
            endd
         endi
         if col()>=pbcol
            if row()=pbrow
               SetPos(ptrow,ptcol)
            else
               SetPos(row()+1,ptcol)
            endi
            tone(2000,3)
         else
            SetPos(row(),col()+1)
         endi
         if vReadChar()=chr(4)
            do whil vReadChar()=chr(4)
               SetPos(row(),col()-1)
            endd
            SetPos(row(),col()+1)
         endi
      case x=5                                   && up arrow
         if row()=ptrow
            if col()=ptcol
               SetPos(pbrow,pbcol)
            else
               SetPos(pbrow,col()-1)
            endi
            tone(2000,3)
         else
            SetPos(row()-1,col())
         endi
         if vReadChar()=chr(4)
            do whil vReadChar()=chr(4)
               SetPos(row(),col()-1)
            endd
            SetPos(row(),col()+1)
         endi
      case x=24.or.x=10                          && down arrow
         if row()=pbrow
            if col()=pbcol
               SetPos(ptrow,ptcol)
            else
               SetPos(ptrow,col()+1)
            endi
            tone(2000,3)
         else
            SetPos(row()+1,col())
         endi
         if vReadChar()=chr(4)
            do whil vReadChar()=chr(4)
               SetPos(row(),col()-1)
            endd
            SetPos(row(),col()+1)
         endi
      case x=22                                  && insert key
         if vReadChar(row(),pbcol)!=' '
            pSoundError()
            loop
         endi
         vscroll(row(),col(),row(),pbcol,'r',1)
         for x=1 to no_fields
            if fld_row[x]=row().and.fld_col[x]>=col()
               fld_col[x]=fld_col[x]+1
            endi
         next
      case x=7                                   && delete key
         if vReadChar()=chr(4)
            pSoundError()
            loop
         endi
         vscroll(row(),col(),row(),pbcol,'l',1)
         for x=1 to no_fields
            if fld_row[x]=row().and.fld_col[x]>col()
               fld_col[x]=fld_col[x]-1
            endi
         next
      case x=8                                   && backspace key
         if col()=ptcol
            pSoundError()
            loop
         endi
         SetPos(row(),col()-1)
         if vReadChar()=chr(4)
            pSoundError()
            SetPos(row(),col()+1)
            loop
         endi
         vscroll(row(),col(),row(),pbcol,'l',1)
         for x=1 to no_fields
            if fld_row[x]=row().and.fld_col[x]>col()
               fld_col[x]=fld_col[x]-1
            endi
         next
      case x=274                                 && exit
         exit
      case x=286                                 && abort
         poscr(ptrow,ptcol,pbrow,pbcol,stype)
         vRestore(xscreen)
         retu temptem
      case x=289                                 && fields
         curcurs=vCursSave()
         vSaveIt(2,29,7,38)
         vBorder(2,29,7,38)
         IF lUseColor
            vNewColor(1,10,1,10,'w/b')
            vNewColor(1,30,1,30,'w/b')
            vNewColor(1,50,1,50,'w/b')
            vNewColor(1,70,1,70,'w/b')
         ENDIF
         @ 3,30 say 'Next'
         @ 4,30 say 'Previous'
         @ 5,30 say 'Create'
         @ 6,30 say 'Delete'
         IF lUseColor
            vNewColor(3,30,3,30,'b/g')
            vNewColor(4,30,4,30,'b/g')
            vNewColor(5,30,5,30,'b/g')
            vNewColor(6,30,6,30,'b/g')
         ENDIF
         opt=' '
         do whil !opt$'NPCD'+chr(27)
            opt=upper(chr(inkey(0)))
         endd
         vRestore()
         vCursRest(curcurs)
         do case
         case opt=chr(27)
            pSoundError()
            loop
         case opt='N'
            foundit=.n.
            if vReadChar()=chr(4)
               do whil vReadChar()=chr(4)
                  if col()=pbcol
                     if row()=pbrow
                        foundit=.y.
                        pSoundError()
                        vCursRest(curcurs)
                        exit
                     endi
                     SetPos(row()+1,ptcol)
                  else
                     SetPos(row(),col()+1)
                  endi
               endd
               if foundit
                  loop
               endi
            endi
            do whil .y.
               if col()=pbcol
                  if row()=pbrow
                     exit
                  endi
                  SetPos(row()+1,ptcol)
               else
                  SetPos(row(),col()+1)
               endi
               if vReadChar()=chr(4)
                  foundit=.y.
                  exit
               endi
            endd
            if !foundit
               vCursRest(curcurs)
               pSoundError()
            endi
         case opt='P'
            *curcurs=vCursSave()
            foundit=.n.
            do whil .y.
               if col()=ptcol
                  if row()=ptrow
                     exit
                  endi
                  SetPos(row()-1,pbcol)
               else
                  SetPos(row(),col()-1)
               endi
               if vReadChar()=chr(4)
                  foundit=.y.
                  exit
               endi
            endd
            if !foundit
               vCursRest(curcurs)
               pSoundError()
            endi
            if vReadChar()=chr(4)
               do whil vReadChar()=chr(4)
                  SetPos(row(),col()-1)
               endd
               SetPos(row(),col()+1)
            endi
         case opt='C'
            if vReadChar()!=' '
               pSoundError()
               loop
            endi
            max_width=pbcol-col()+1
            for x=col() to col()+max_width-1
               if vReadChar(row(),x)!=' '
                  max_width=x-col()
                  exit
               endi
            next
            no_fields=no_fields+1
            vSaveIt(7,19,if(usefldnms,14,13),59)
            vBorder(7,19,if(usefldnms,14,13),59)
            aa='Creating a field'
            @ 8,vCenterPos(aa) say aa
            @ 9,21 say 'Field #'+ltrim(str(no_fields))
            @ 10,21 say 'Maximum width ... '+ltrim(str(max_width))+' columns'
            @ 11,21 say 'Field type ...... Character'
            @ 12,21 say 'Picture .........'
            if usefldnms
               @ 13,21 say 'Field name ......'
               fname=space(22)
            endi
            ftype='C'
            fpix=space(max_width)
            @ 11,39 get ftype pict typefunc() vali validtype(ftype)
            @ 12,39 get fpix pict pixfunc() vali validpix(fpix)
            if usefldnms
               @ 13,39 get fname pict '@!'
            endi
            read
            vRestore()
            vCursRest(curcurs)
            if !acceptit()
               no_fields=no_fields-1
               loop
            endi
            if usefldnms
               fld_name[no_fields]=trim(fname)
            endi
            fld_type[no_fields]=ftype
            fld_pix[no_fields]=trim(fpix)
            fld_row[no_fields]=row()
            fld_col[no_fields]=col()
            vRepHorz(chr(4),len(fld_pix[no_fields]))
            if no_fields>1
               jwb_asort(no_fields)
            endi
         case opt='D'
            if vReadChar()!=chr(4)
               pSoundError()
               loop
            endi
            ptr=jwb_afind(row(),col())
            vRepHorz(' ',len(fld_pix[ptr]))
            no_fields=no_fields-1
            if usefldnms
               adel(fld_name,ptr)
            endi
            adel(fld_type,ptr)
            adel(fld_pix,ptr)
            adel(fld_row,ptr)
            adel(fld_col,ptr)
         endc
      endc
   endd
   gc=GetEm(ptrow,ptcol,pbrow,pbcol)
   vRestore()
   vRestore(xscreen)
   a=chr(254)
   sendback=chr(255)+ltrim(str(ptrow))+a+ltrim(str(ptcol))+a+ltrim(str(pbrow))+a+ltrim(str(pbcol))+a
   for x=1 to no_fields
      sendback=sendback+if(usefldnms,fld_name[x],'')+fld_type[x]+a+fld_pix[x]+a+ltrim(str(fld_row[x]))+a+ltrim(str(fld_col[x]))+a
   next
   retu sendback+chr(25)+gc
ENDFUNCTION

STATIC FUNCTION sndwakeup
   tone(2000,1)
   tone(1000,1)
   tone(2000,3)
   tone(500,3)
   tone(2000,3)
   tone(2000,1)
   tone(1000,1)
   retu 0
ENDFUNCTION

STATIC FUNCTION warning(p1)
   priv x, msg
   msg := p1
   vSaveIt(11,vCenterPos(msg)-1,13,vCenterPos(msg)+len(msg))
   vBorder(11,vCenterPos(msg)-1,13,vCenterPos(msg)+len(msg))
   @ 12,vCenterPos(msg) say msg
   iif(lUseColor, vNewColor(11,vCenterPos(msg)-1,13,vCenterPos(msg)+len(msg),'r+/w'),)
   x=0
   do whil !upper(chr(x))$'YN'
      x=inkey()
   endd
   vRestore()
   retu if(upper(chr(x))='Y',.y.,.n.)
ENDFUNCTION

STATIC FUNCTION validtype(p1)
   priv really, tchar
   tchar := p1
   really=.y.
   do case
   case tchar='C'
      @ 11,39 say 'Character'
   case tchar='L'
      @ 11,39 say 'Logical  '
      fpix='Y'
      keyb chr(13)
   case tchar='N'
      @ 11,39 say 'Numeric  '
   case tchar='D'
      @ 11,39 say 'Date     '
      fpix='99/99/99'
      keyb chr(13)
   othe
      really=.n.
   endc
   retu really
ENDFUNCTION

STATIC FUNCTION acceptit
   priv ytoaccept,a,curcurs
   curcurs=vCursSave()
   set curs off
   ytoaccept=(pRandom(2)=1)
   aa=if(ytoaccept,'Accept it','Change it')+' (Y/N)?'
   vSaveIt(11,vCenterPos(aa)-1,13,vCenterPos(aa)+len(aa))
   vBorder(11,vCenterPos(aa)-1,13,vCenterPos(aa)+len(aa))
   @ 12,vCenterPos(aa) say aa
   iif(lUseColor, vNewColor(11,vCenterPos(aa)-1,13,vCenterPos(aa)+len(aa),'n/r'),)
   do whil .y.
      a=upper(chr(inkey(0)))
      if a$'YN'
         exit
      endi
   endd
   vRestore()
   set curs on
   vCursRest(curcurs)
   retu if(ytoaccept,if(a='Y',.y.,.n.),if(a='N',.y.,.n.))
ENDFUNCTION

STATIC FUNCTION jwb_asort(p1)
   priv number := p1
   priv x,tarray[number],trow[number],tcol[number],ttype[number],tpix[number]
   for x=1 to number
      tarray[x]=str(fld_row[x],3)+str(fld_col[x],3)+str(x,3)
   next
   asort(tarray)
   for x=1 to number
      trow[x]=val(left(tarray[x],3))
      tcol[x]=val(substr(tarray[x],4,3))
      ttype[x]=fld_type[val(right(tarray[x],3))]
      tpix[x]=fld_pix[val(right(tarray[x],3))]
   next
   for x=1 to number
      fld_row[x]=trow[x]
      fld_col[x]=tcol[x]
      fld_type[x]=ttype[x]
      fld_pix[x]=tpix[x]
   next
   retu 0
ENDFUNCTION

STATIC FUNCTION jwb_afind(p1, p2)
   priv ttrow := p1,ttcol := p2, x
   for x=1 to no_fields
      if ttrow=fld_row[x].and.ttcol=fld_col[x]
         exit
      endi
   next
   if x>no_fields
      retu 0
   endi
   retu x
ENDFUNCTION

STATIC FUNCTION typefunc
   priv aa,acurs
   acurs=vCursSave()
   aa='C/haracter  L/ogical  N/umeric  D/ate'
   @ 23,vCenterPos(aa) say aa
   iif(lUseColor, vNewColor(23,0,23,79,'n/gr'),)
   vCursRest(acurs)
   retu '@! A'
ENDFUNCTION

STATIC FUNCTION pixfunc
   priv aa,acurs
   acurs=vCursSave()
   aa='<A>=A-Z, <9>=0-9, <X>=anything, <.>=decimal'
   @ 23,vCenterPos(aa) say aa
   iif(lUseColor, vNewColor(23,0,23,79,'n/gr'),)
   vCursRest(acurs)
   retu '@!S20'
ENDFUNCTION

STATIC FUNCTION validpix(p1)
   priv aa,abox, pix := p1
   if empty(pix)
      pSoundError()
      abox=vSaveIt(23,0,23,79)
      @ 23,0
      aa='PICTURE CANNOT BE EMPTY'
      @ 23,vCenterPos(aa) say aa
      inkey(2)
      vRestore(abox)
      retu .n.
   endi
   retu .y.
ENDFUNCTION

STATIC FUNCTION puscr(p1, p2, p3, p4, p5)
   priv tr := p1,tc := p2,br := p3,bc := p4,st := p5
   if st=255
      vSaveIt(tr-1,tc-1,br+1,bc+1)
      vBorder(tr-1,tc-1,br+1,bc+1)
   elseif st=251
      vSaveIt(tr-1,tc-1,br+1,bc+1)
      vBorder(tr-1,tc-1,br+1,bc+1)
   else
      vSaveIt(tr,tc,br,bc)
   endi
   retu 0
ENDFUNCTION

STATIC FUNCTION poscr(p1, p2, p3, p4, p5)
   priv tr := p1,tc := p2,br := p3,bc := p4,st := p5
   if st=255
      vRestore()
   elseif st=251
      vRestore()
   else
      vRestore()
   endi
   retu 0
ENDFUNCTION

STATIC FUNCTION vd_help
   retu 0
ENDFUNCTION

STATIC FUNCTION wndheight
   retu 0
ENDFUNCTION

STATIC FUNCTION vSaveIt(a,b,c,d)
   LOCAL nReturn
   nReturn := vSave(a,b,c,d)
   iif(a=NIL, a := 0, NIL)
   iif(b=NIL, b := 0, NIL)
   iif(c=NIL, c := 24, NIL)
   iif(d=NIL, d := 79, NIL)
   @ a,b clear to c,d
   RETURN nReturn
ENDFUNCTION

STATIC FUNCTION GetEm(a,b,c,d)
   LOCAL cReturn := ""
   aEval(vReadLines(a,b,c,d), {|e| cReturn += e+chr(141)})
   RETURN cReturn
ENDFUNCTION
