page    60,132
;
;******************************************************************************
;       09/02/89
;******************************************************************************
;
title   BINMODE.ASM              Clipper printer functions
; Notice:
;   Released to the public domain
;   on  5/04/89 11:50 pm
;   by Accfin Software, Inc
; Author:
;   Jud Cole  2/13/89 10:56 am
; Updates/enhancements/suggestions:
;   Brad H. Codd CIS 73427,1172
;
.radix 16d
;
;*****************************************************************************
;
include extenda.inc
;
CODESEG BINMODE
;
WORKFUNCS
;
assume cs:binmode_text,ds:binmode_text,es:binmode_text
;
.sall
;
;*****************************************************************************
;                               Public functions
;*****************************************************************************
;
CLpublic        <binmode>
;
;*****************************************************************************
;               BINMODE          Set printer to binary mode
;*****************************************************************************
;
;       Usage
;               binmode (outmod)
;       Parameters
;               outmod = 0 if normal mode (check for 1A)
;                        any other if binary mode
;       Returns
;               none
;
;       Example
;               OFF = 0
;               ON = 1
;               SET PRINT ON
;               BINMODE(ON)
;               ?? <binary data>
;               BINMODE(OFF)
;               SET PRINT OFF
;
;*****************************************************************************
        CLfunc  void    binmode <int outmod>
        CLcode
        mov     ax,4400                         ; IOCTL get status
        mov     bx,4                            ; Printer handle
        int     21                              ; Get it
        cmp     outmod,0                        ; Is it set to normal?
        jne     setbin                          ; No - set to binary
        and     dl,0dfh                         ; Clear binary bit
        jmp     short setmod
setbin:
        or      dl,20                           ; Set binary bit
setmod:
        mov     ax,4401                         ; IOCTL set status
        mov     bx,4                            ; Printer handle
        mov     dh,0                            ; Not allowed to use these
        int     21                              ; Set the mode
        CLret                                   ; Return
;
;*****************************************************************************
;
;*****************************************************************************
;
        end
