#include "inkey.ch" 
#include "setcurs.ch" 
#include "bg.ch" 

co_norm := "B/BG,BR/W,,,N/W"
co_box  := "N/W"
text    := "Share everything. Play fair. Don't hit people. Put things " + ;
           "back where you found them. Clean up your own mess. Don't take " + ;
           "things that aren't yours. Say you're sorry when you hurt " + ;
           "somebody. Wash your hands before you eat. Flush. Warm " + ;
           "cookies and cold milk are good for you. Live a balanced " + ;
           "life-learn some and think some and draw and paint and " + ;
           "sing and dance and play and work every day some. Take a nap" + ;
           "every afternoon. When you go out into the world, watch out " + ;
           "for traffic, hold hands and stick together. Be aware of wonder. " + ;
           "[This is a small excerpt from, 'All I Really Need to Know I Learned " + ;
           "in Kindergarten']" 

SET CURSOR OFF

SETCOLOR(co_norm)
clear 

TEST_BR1(8,11,18,68)         

SET CURSOR ON
quit

* endeof : example.prg 

*******************************

FUNCTION test_br1(t,l,b,r)
   LOCAL browse, column, lastk, done := .f., index := 1

   SETCOLOR(co_box)
   @ 5,25 say "T B R O W S E   E X A M P L E"
   @ t, l, b, r BOX "͸Գ"

   SETCOLOR(co_norm)

   /* make a new browse object */
   browse := TBrowseDB(t+1, l+1, b, r-1)

   /* default heading and column separators */
   browse:headSep := MY_HSEP
   browse:colSep  := MY_CSEP
   browse:footSep := MY_FSEP

   /* define top and bottom */
   browse:gotopblock    := { || index := 1 }
   browse:gobottomblock := { || index := MLCOUNT( text, column:width ) }

   /* add custom 'skip UDF' */
   browse:skipBlock := {|x| Skip_Memo(x, column, @index )}

   /* specify colors     1    2     3     4     5     6    7  */
   browse:colorSpec := "N/W, B/W, B/BG, W+/GR, B/BG"

   /* make a new column <1> */
	column := TBColumnNew( "Line #", {|| ("  " + STR(index,2) + "  " ) })
   column:defColor := {2, 3}
	browse:addColumn(column)

   /* make a new column <2> */
   column := TBColumnNew("   Text Field - Story Information", {|| MemoLine( text, column:width, index )} )
   column:defColor := {2, 3}
   column:width    := 40
   browse:addColumn(column)

   /* define highlight bar */
   browse:autoLite := .f.

   WHILE ( ! done )

      browse:ColorRect({browse:rowPos, 1, browse:rowPos, browse:colCount}, {2, 3})

      /* stabilize the display */
      WHILE ( ! browse:STABILIZE() )

         IF ( (lastk := INKEY()) # 0 )
            exit          /* (abort if a key is waiting) */
         ENDIF

      ENDDO

      browse:ColorRect({browse:rowPos, 1, browse:rowPos, browse:colCount}, {4, 4})

      IF ( browse:stable )
         lastk := INKEY(0)
      ENDIF

      /* process key */
      DO CASE
         CASE ( lastk == K_DOWN ) .or. ( lastk == K_RETURN )
            browse:DOWN()

         CASE ( lastk == K_UP )
            browse:UP()

         CASE ( lastk == K_PGDN )
            browse:PAGEDOWN()

         CASE ( lastk == K_PGUP )
            browse:PAGEUP()

         CASE ( lastk == K_RIGHT )
            browse:RIGHT()

         CASE ( lastk == K_LEFT )
            browse:LEFT()

         CASE ( lastk == K_HOME )
            browse:HOME()

         CASE ( lastk == K_END )
            browse:END()

         CASE ( lastk == K_ESC )
            done := .t.

      ENDCASE

   ENDDO

   return .t.
* endfunc

FUNCTION skip_memo(n, skipColumn, index)
   LOCAL moved := 0, max := MLCount( text, skipColumn:width )

   IF ( n >= 0)

      IF (index + n) > max  
         moved := max - index
         index := max

      ELSE
         moved := n
         index += n

      ENDIF

   ELSE

      IF (index + n) < 1
         moved := 1 - index
         index := 1

      ELSE
         moved := n
         index += n

      ENDIF

   ENDIF
  	
   return moved
* endfunc

