#include "inkey.ch" 
#include "setcurs.ch" 
#include "bg.ch" 

co_norm := "B/BG,BR/W,,,N/W"
co_box  := "N/W"

SET CURSOR OFF

SETCOLOR(co_norm)
clear 

USE test NEW

TEST_BR1(8,11,18,68)         

SET CURSOR ON
quit

* endeof : example.prg 

*******************************

FUNCTION test_br1(t,l,b,r)
   LOCAL browse, column, lastk, done := .f. 

   SETCOLOR(co_box)
   @ 5,25 say "T B R O W S E   E X A M P L E"
   @ t, l, b, r BOX "͸Գ"

   SETCOLOR(co_norm)

   /* create a new TBrowse object */
   browse := TBrowseDB(t+1, l+1, b, r-1)

   /* default heading and column separators */
   browse:headSep := MY_HSEP
   browse:colSep  := MY_CSEP
   browse:footSep := MY_FSEP

   /* specify colors     1    2     3     4     5     6    7  */
   browse:colorSpec := "N/W, B/W, B/BG, GR+/W, B/BG, R/W, BG/R"

   /* make a new column <1> */
   column := TBColumnNew("", {|| x } )

   column:heading  := "   Name"
   column:block    := {|| TRIM(fname) + " " + TRIM(lname) }

   column:defColor := {2, 3}
*  column:width    := 20
*  column:cargo    := "name"

   browse:addColumn(column)

   /* make a new column <2> */
   column := TBColumnNew("Score 1", {|x| if(x == NIL, test->score_1, test->score_1 := x) } )
   column:headSep    := MY_HSEP2
   column:colSep     := MY_CSEP2
   column:footSep    := MY_FSEP2
   column:colorBlock := {|x| if( x < 0, {6, 7}, {4, 5} )}
   browse:addColumn(column)

   /* make a new column <3> */
   column := TBColumnNew("Score 2", {|x| if(x == NIL, test->score_2, test->score_2 := x) } )
   column:colorBlock := {|x| if( x < 0, {6, 7}, {4, 5} )}
   browse:addColumn(column)

   WHILE ( ! done )

      /* stabilize the display */
      WHILE ( ! browse:STABILIZE() )
         lastk := INKEY()

         IF ( lastk != 0 )
            exit          /* (abort if a key is waiting) */
         ENDIF
      ENDDO

      IF ( browse:stable )
         lastk := INKEY(0)
      ENDIF

      /* process key */
      DO CASE

         CASE ( lastk == K_DOWN )
            browse:DOWN()

         CASE ( lastk == K_UP )
            browse:UP()

         CASE ( lastk == K_PGDN )
            browse:PAGEDOWN()

         CASE ( lastk == K_PGUP )
            browse:PAGEUP()

         CASE ( lastk == K_RIGHT )
            browse:RIGHT()

         CASE ( lastk == K_LEFT )
            browse:LEFT()

         CASE ( lastk == K_HOME )
            browse:HOME()

         CASE ( lastk == K_END )
            browse:END()

         CASE ( lastk == K_ESC )
            done := .t.

      ENDCASE

   ENDDO

   return .t.
* endfunc
