#include "inkey.ch" 
#include "setcurs.ch" 
#include "bg.ch" 

co_norm := "B/BG,BR/W,,,N/W"
co_box  := "N/W"

SETCURSOR(0)

SETCOLOR(co_norm)
clear 

PUBLIC big_array := { {"chicken", "fish", "turkey", "sushi" },;
                      {"wine", "beer", "water", "plum wine" }, ;
                      { "apple pie", "carrot cake", "ice cream", "cookies" } }

TEST_BR1(8,11,18,68)         

SETCURSOR(1)
quit

* endeof : example.prg 

*******************************

FUNCTION test_br1(t,l,b,r)
   LOCAL browse, column, lastk, done := .f. , index := 1

   SETCOLOR(co_box)
   @ 5,25 say "T B R O W S E   E X A M P L E"
   @ t, l, b, r BOX "͸Գ"

   SETCOLOR(co_norm)

   /* create a new TBrowse object */
   browse := TBrowseDB(t+1, l+1, b, r-1)

   /* default heading and column separators */
   browse:HeadSep := MY_HSEP
   browse:ColSep  := MY_CSEP
   browse:footSep := MY_FSEP

   /* define top and bottom */
   browse:gotopblock    := { || index := 1 }
   browse:gobottomblock := { || index := LEN(big_array) }

   /* add custom 'skip UDF' */
   browse:skipBlock := {|x| Skip_it(x,@index)}

   /* specify colors     1    2     3     4     5     6    7  */
   browse:colorSpec := "N/W, B/W, B/BG, GR+/W, B/BG, R/W, BG/R"

   /* make a new column <1> */
   column := TBColumnNew("Main Course",;
     {|x| if(x == NIL, big_array[1,index], big_array[1,index]:= x) } )

   column:defColor := {2, 3}
   column:width    := 10
   browse:addColumn(column)

   /* make a new column <2> */
   column := TBColumnNew("Drinks",; 
     {|x| if(x == NIL, big_array[2,index], big_array[2,index]:= x) } )

   column:defColor := {2, 3}
   column:width    := 10
   browse:addColumn(column)

   /* make a new column <3> */
   column := TBColumnNew("  Desserts",; 
     {|x| if(x == NIL, big_array[3,index], big_array[3,index]:= x) } )

   column:defColor := {2, 3}
   column:width    := 15
   browse:addColumn(column)

   WHILE ( ! done )

      /* stabilize the display */
      WHILE ( ! browse:STABILIZE() )
         lastk := INKEY()

         IF ( lastk != 0 )
            exit          /* (abort if a key is waiting) */
         ENDIF
      ENDDO

      IF ( browse:stable )
         lastk := INKEY(0)
      ENDIF

      /* process key */
      DO CASE

         CASE ( lastk == K_DOWN )
            browse:DOWN()

         CASE ( lastk == K_UP )
            browse:UP()

         CASE ( lastk == K_PGDN )
            browse:PAGEDOWN()

         CASE ( lastk == K_PGUP )
            browse:PAGEUP()

         CASE ( lastk == K_RIGHT )
            browse:RIGHT()

         CASE ( lastk == K_LEFT )
            browse:LEFT()

         CASE ( lastk == K_HOME )
            browse:HOME()

         CASE ( lastk == K_END )
            browse:END()

         CASE ( lastk == K_ESC )
            done := .t.

      ENDCASE

   ENDDO

   return .t.
* endfunc

FUNCTION skip_it(n,index)
   LOCAL moved := 0, max := LEN(big_array[1])

   IF ( n >= 0)

      IF (index + n) > max  
         moved := max - index
         index := max

      ELSE
         moved := n
         index += n

      ENDIF

   ELSE

      IF (index + n) < 1
         moved := 1 - index
         index := 1

      ELSE
         moved := n
         index += n

      ENDIF

   ENDIF
  	
   return moved
* endfunc

