POP_IT()

FUNCTION pop_it

   #include "inkey.ch" 
   #include "setcurs.ch" 
   #include "bg.ch" 

   co_norm := "B/BG,BR/W,,,N/W"
   co_box  := "N/W"

   USE jobs NEW
   INDEX on posit_type TO jobs

   USE test NEW

   SET CURSOR OFF

   SETCOLOR(co_norm)
   clear 

   Test_Pop(8,11,18,68)         

   SET CURSOR ON
   quit

* endfunc

*******************************

FUNCTION test_pop(t,l,b,r)
   LOCAL browse, column, lastk, done := .f., index := 1

   SETCOLOR(co_box)
   @ 5,25 say "T B R O W S E   E X A M P L E"
   @ t, l, b, r BOX "͸Գ"

   SETCOLOR(co_norm)

   /* make a new browse object */
   browse := TBrowseDB(t+1, l+1, b, r-1)

   /* default heading and column separators */
   browse:headSep := MY_HSEP
   browse:colSep  := MY_CSEP
   browse:footSep := MY_FSEP

   /* specify colors     1    2     3     4     5   */
   browse:colorSpec := "N/W, B/W, B/BG, W+/GR, BR/W"

   /* make a new column <1> */
   column := TBColumnNew("        Name", {|| TRIM(test->fname) + " " + TRIM(test->lname) } )
   column:defColor := {2, 3}
   column:width    := 20
   column:cargo    := "name"
   browse:addColumn(column)

   /* make a new column <2> */
   column := TBColumnNew("Job Title", {|x| if(x == NIL, test->position, test->position := x) } )
   column:defColor := {5, 3}
   column:width    := 10
   browse:addColumn(column)

   WHILE ( ! done )

      /* stabilize the display */
      WHILE ( ! browse:STABILIZE() )
         IF ( (lastk := INKEY()) # 0 )
            exit          /* (abort if a key is waiting) */
         ENDIF
      ENDDO

      IF ( browse:stable )
         lastk := INKEY(0)
      ENDIF

      /* process key */
      DO CASE
         CASE ( lastk == K_DOWN )
            browse:DOWN()

         CASE ( lastk == K_UP )
            browse:UP()

         CASE ( lastk == K_PGDN )
            browse:PAGEDOWN()

         CASE ( lastk == K_PGUP )
            browse:PAGEUP()

         CASE ( lastk == K_RIGHT )
            browse:RIGHT()

         CASE ( lastk == K_LEFT )
            browse:LEFT()

         CASE ( lastk == K_HOME )
            browse:HOME()

         CASE ( lastk == K_END )
            browse:END()

         CASE ( lastk == K_ESC )
            done := .t.

         CASE ( lastk == K_RETURN )
           /* don't allow editing of first or last column */
           column:= browse:GetColumn(browse:colPos)
 
           IF ( column:cargo == "name")
              loop
           ELSE
              Get_Job(browse)
           ENDIF

      ENDCASE

   ENDDO

   return .t.
* endfunc

*******************************************

FUNCTION get_job(bget)
   LOCAL max, a_posit[max := jobs->(LASTREC())], brow, cnt

   /* put the job positions in an array  */

   SELECT jobs
   go top

   FOR k := 1 TO max
      a_posit[k] := jobs->posit_type
      skip
   NEXT

   SELECT test

   brow  := 20  
   cnt   := (brow - 7) + 1  
 
   IF cnt > max 
      brow := brow - (cnt - max)  
      cnt  := max   
   ENDIF 

   REPLACE test->position WITH My_Choice(6,9,brow+1,22,;
               a_posit,ASCAN(a_posit,test->position))

   /* force redisplay of current row */
   bget:refreshCurrent()

   return .t.
* endfunc 

FUNCTION my_choice(t,l,b,r,the_array,begat)
   LOCAL browse, column, lastk, done := .f., index := 1, pbuff := "", retval := ""

   SETCOLOR(co_box)

   pbuff := SAVESCREEN(6,9,b+1,22) 
   @ t, l, b, r BOX "͸Գ"

   /* make a new browse object */
   browse := TBrowseDB(t+1, l+1, b, r-1)

   /* default heading and column separators */
   browse:headSep := MY_HSEP
   browse:colSep  := MY_CSEP
   browse:footSep := MY_FSEP

   /* define top and bottom */
   browse:gotopblock    := { || index := 1 }
   browse:gobottomblock := { || index := LEN(the_array) }

   /* add custom 'skip UDF' */
   browse:skipBlock := {|x| Skip_it(x,@index,the_array)}

   /* specify colors     1    2     3     4      5     6    */
   browse:colorSpec := "N/W, B/W, B/BG, W+/GR, GR+/W, N/BG"

   /* make a new column <1> */
   column := TBColumnNew("Job Names", {|| the_array[index] })
   column:defColor := {5, 6}
   column:width    := 10
   browse:addColumn(column)

   /* position at the current element */
   Skip_it(begat-1,@index,the_array)

   WHILE ( ! done )

      /* stabilize the display */
      WHILE ( ! browse:STABILIZE() )
         IF ( (lastk := INKEY()) # 0 )
            exit        
         ENDIF
      ENDDO

      IF ( browse:stable )
         lastk := INKEY(0)
      ENDIF

      /* process key */
      DO CASE
         CASE ( lastk == K_DOWN )
            browse:DOWN()

         CASE ( lastk == K_UP )
            browse:UP()

         CASE ( lastk == K_PGDN )
            browse:PAGEDOWN()

         CASE ( lastk == K_PGUP )
            browse:PAGEUP()

         CASE ( lastk == K_RIGHT )
            browse:RIGHT()

         CASE ( lastk == K_LEFT )
            browse:LEFT()

         CASE ( lastk == K_ESC )
            retval := the_array[index]
            done := .t.

         CASE ( lastk == K_RETURN )
            retval := the_array[index]
            done   := .t.

      ENDCASE

   ENDDO

   RESTSCREEN(6,9,b+1,22,pbuff) 
   SETCOLOR(co_norm)

   return retval
* endfunc

FUNCTION skip_it(n,index,the_array)
   LOCAL moved := 0, max := LEN(the_array)

   IF ( n >= 0)
      IF (index + n) > max  
         moved := max - index
         index := max
      ELSE
         moved := n
         index += n
      ENDIF

   ELSE

      IF (index + n) < 1
         moved := 1 - index
         index := 1
      ELSE
         moved := n
         index += n
      ENDIF
   ENDIF
  	
   return moved
* endfunc

