* Program..:  Betdates.prg
* Author...:  Martin Schiff
* Date.....:  February 6,1987
* Notice...:  Custom Data Solutions, 1987, All rights reserved.
* Notes....:  Betdates.prg 
* 
* This routine will take as input a start date and a finish date, and return
* the number of months and additional days between the 2 dates.  The
* routine actually figures the number of nights since it is for the travel
* industry, but could be easily modified to measure the span including the 
* start and finish date.  The number of months is returned in tMONTHS, and
* the number of days extra in tDAYS.
* 
* If you run the program with talk set on, and you watch the dates change
* using a date with 31 for the you will notice that as the program executes
* you can see the last date of the month change from 31 to 30 and back, and
* to 28 or 29 in February.
*
* This routine may be incorporated in your programs as long as the header 
* remains intact.

PARAMETERS tMONTHS,tDAYS,START,FINISH
holdate=start
prevhold=start
dofdep=finish             && dofdep -- date of departure
periods=0
xdays=0
needtest=.f.
if day(start)>28
  needtest=.t.
endif
changed=.f.
day=substr(dtoc(holdate),4,2)    
oldday=day
do while holdate < dofdep    
  prevhold=holdate    
  if changed                   && if we have changed from the original day
    day=oldday                 && change it back
  else
    day=substr(dtoc(holdate),4,2)    
  endif
  month=substr(dtoc(holdate),1,2)    
  year=substr(dtoc(holdate),7,2)    
** The following routine moves you to a date one month from the date stored
** in holdate.
  if month = '12'    
    month='01'    
    year=str((val(year)+1),2)    
  else    
    if needtest              && the day of the month is > 28
      if val(month)=1    
        changed=.t.    
        oldday=day    
        if mod(year(holdate),4)=0               && if it is a leapyear
          day='29'        
        else        
          day='28'        
        endif        
      else    
        if val(day)=31    
          m=val(month)    
          if m=3 .or. m=5 .or. m=8 .or. m=10         && if prev month had 30
            changed=.t.                              && days
            oldday=day    
            day='30'    
          endif    
        endif    
      endif        
    endif
    month=str((val(month)+1),2)          
  endif          
  holdate=ctod(month+'/'+day+'/'+year)          
  if holdate <= dofdep          
    periods=periods+1          
  else          
    xdays=dofdep-prevhold
  endif          
enddo        
tmonths=periods      
tdays=xdays      

RETURN      

    ........................ . ... ... .... 1200  N81N          ........................ . ... ... .... 1200  N81N          ........................ . ... ... .... 1200  N81N          ........................ . ... ... .... 1200  N81N          ............