EDITORS NOTE:
Here's an assembly routine, submitted by ace anomaly detective
Pete Bechtel, that you can CALL from Clipper programs anytime
you need a short 'sonic' reminder.

-ROGER

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                               B E E _ B O P . A S M
;
; COPYRIGHT 1984 - ALL RIGHTS RESERVED
; PEN & INK SOFTWARE, LTD., RESEARCH TRIANGLE PARK, NC
; LAST UPDATE: 12/31/83
;
; AUTHOR:      PETE BECHTEL
; ENVIRONMENT: COLUMBIA MPC 1600-1, MSDOS 2.00, MICROSOFT MASM,LINK
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
TITLE BEE_BOP
;
;
DATA    SEGMENT PUBLIC 'DATA'
WRU     DB      'Copyright 1984 Pen & Ink Software, LTD'
DATA    ENDS
;
DGROUP  GROUP   DATA
CODE    SEGMENT 'CODE'
        ASSUME  CS:CODE, DS:DGROUP, SS:DGROUP
        PUBLIC  BEE_BOP

BEE_BOP PROC    FAR                     ; STANDARD PROGRAM SET-UP
        PUSH    BP
        PUSH    DS

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                       M A I N   P R O G R A M
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;
; GENERATE A COUPLE OF DIFFERENT TONES FOR 1/2 SECOND EACH
;
        IN      AL,61H                  ; SET SPEAKER PORT STATUS BYTE FOR RET
        PUSH    AX                      ; AND SAVE IT
;;
        CLI                             ; NOP, WAS CLI = DISABLE ALL INTERRUPTS

;
        MOV     CX,900                  ; DURATION OF 'ON' TIME
        ADD     CX,200                  ; DECREMENT FREQ
;
        MOV     DX,030                  ; ENTER DURATION
        IN      AL,61H                  ; GET CURRENT VALUE OF PORT PB
        AND     AL,0F3H                 ; FORCE TIMER 2 GATE BIT OFF
AGAIN:  OR      AL,2                    ; SET 'SPEAKER DATA' BIT ON
        OUT     61H,AL                  ; WRITE PORT PB
        MOV     CX,900                  ; DURATION OF 'ON' TIME
;
WAIT1:  LOOP    WAIT1                   ; DELAY WHILE 'SPEAKER DATA' = 1
        AND     AL,0FDH                 ; SET 'SPEAKER DATA' BIT OFF
        OUT     61H,AL                  ; WRITE PORT PB
        MOV     CX,900                  ; DURATION OF 'OFF' TIME
WAIT2:  LOOP    WAIT2                   ; DELAY WHILE 'SPEAKER DATA' = 0
;
; ONE SQUARE WAVE CYCLE HAS NOW BEEN COMPLETED.
;
        DEC     DX                      ; COUNT DOWN # CYCLES LEFT
        JNZ     AGAIN                   ; BRANCH IF MORE TO DO
;
; DURATION HAS BEEN ACCOMPLISHED, NOW CHANGE FREQUENCY AND REPEAT IT

        MOV     CX,1100                 ; DURATION OF 'ON' TIME
        ADD     CX,200                  ; DECREMENT FREQ
;
        MOV     DX,030                  ; ENTER DURATION
        IN      AL,61H                  ; GET CURRENT VALUE OF PORT PB
        AND     AL,0F3H                 ; FORCE TIMER 2 GATE BIT OFF
AGAIN2: OR      AL,2                    ; SET 'SPEAKER DATA' BIT ON
        OUT     61H,AL                  ; WRITE PORT PB
        MOV     CX,1100                 ; DURATION OF 'ON' TIME
;
WAIT12: LOOP    WAIT12                  ; DELAY WHILE 'SPEAKER DATA' = 1
        AND     AL,0FDH                 ; SET 'SPEAKER DATA' BIT OFF
        OUT     61H,AL                  ; WRITE PORT PB
        MOV     CX,1100                 ; DURATION OF 'OFF' TIME
WAIT22: LOOP    WAIT22                  ; DELAY WHILE 'SPEAKER DATA' = 0
;
; ONE SQUARE WAVE CYCLE HAS NOW BEEN COMPLETED.
;
        DEC     DX                      ; COUNT DOWN # CYCLES LEFT
        JNZ     AGAIN2                  ; BRANCH IF MORE TO DO
;
;
; TONE HAS NOW BEEN PRODUCED FOR DESIRED DURATION
;
DONE:
        POP     AX                      ; RESTORE ORIGINAL SPEAKER VALUE
        OUT     61H,AL                  ; AND SEND IT TO PORT
        STI                             ; RESTORE INTERRUPTS

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                       C L E A N   U P
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        POP     DS
        POP     BP

        RET                             ; POP STACK 2 BYTES
BEE_BOP ENDP
;
CODE    ENDS
        END
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
