;BEEPER.ASM
;   DIRECT SPEAKER CONTROL FROM CLIPPER
;
;   Released to the public domain by  David L. Ransen, Ph.D.
;                                     SNA Inc.
;                                     P.O. Box 3662
;                                     Princeton, NJ 08543
;                                     August 18, 1986
;
;
;   Call this routine from Clipper, Winter '85 or later, to control
;   the PC's speaker.
;
;   Takes two parameters: frequency in Hz
;                         duration in 100ths of a second
;
;  Calling syntax example: CALL BEEPER WITH WORD(FREQ),WORD(DUR)
;                          where FREQ and DUR are numeric types.
;
;  Some cute applications:
;
;   PROC ATTNBEEP    && get their attention
;
;       CALL BEEPER WITH WORD(1000),WORD(10)
;       CALL BEEPER WITH WORD(1200),WORD(10)
;       CALL BEEPER WITH WORD(1000),WORD(10)
;       CALL BEEPER WITH WORD(1200),WORD(10)
;       CALL BEEPER WITH WORD(1000),WORD(10)
;       RETURN
;
;   PROC ERRBEEP     && sorry, invalid input
;
;       CALL BEEPER WITH WORD(700),WORD(12)
;       CALL BEEPER WITH WORD(500),WORD(12)
;       RETURN
;
;
;
PUBLIC     BEEPER
_PROG      SEGMENT BYTE
ASSUME     CS:_PROG
BEEPER     PROC FAR
           PUSH       BP
           MOV        BP,SP
           PUSH       DS
           PUSH       ES
           ;
           MOV        DI,[BP+6]           ; GET FREQUENCY
           MOV        BX,[BP+8]           ; ...AND DURATION FROM STACK
           MOV        AL,0B6H             ; write timer mode register
           OUT        43H,AL
           MOV        DX,14H
           MOV        AX,4F38H
           DIV        DI
           OUT        42H,AL
           MOV        AL,AH
           OUT        42H,AL
           IN         AL,61H
           MOV        AH,AL
           OR         AL,3                ; turn spkr on
           OUT        61H,AL
    WAIT:  MOV        CX,2801             ; wait 10 msecs
    SPON:  LOOP       SPON
           DEC        BX                  ; DURATION EXPIRED?
           JNZ        WAIT
           MOV        AL,AH
           OUT        61H,AL
           ;
           POP        ES
           POP        DS
           POP        BP
           RET
BEEPER     ENDP
_PROG      ENDS
END
