*******************************************************************
*
* Program..: demo.prg
* Author...: Tom Berend
* Date.....: Feb 22, 1994
* Notice...: Copyright (c) 1994, Data Technology, All Rights Reserved
* Notes....:
*
* Revision History:
*
*
*******************************************************************
*
*    If you have problems or questions using the Radio Beacon library
*    then call Tom Berend at Datatek, 416-230-4974. 
*
*    The Radio Beacon library is copyrighted and subject to the terms of
*    the Data Technology Software Integration Limited licence agreement.
*





#include "Rf.ch"             // bring in the RF command macros

PROCEDURE main(p1,p2,p3)
  local call_list := {},param_line

  // these functions are defined below (as empty stubs for now). feel free
  // to use them in your applications.  

  local udf_list := { {||initialize_transactions()},  ;
                      {||background_process()},       ;
                      {||terminate_transactions()}  }

  // if you want to intercept any command line parameters, then this is
  // the place.   pass the rest to RADIO BEACON.


  param_line = upper(iif (valtype(p1)="C",p1,"") + ;
                     iif (valtype(p2)="C",p2,"") + ;
                     iif (valtype(p3)="C",p3,""))



  // build a 'call table' of functions for your application. 


  #define menu    1            
  #define screens 2                                  
  #define errors  3                                  

       // demo warehouse application

  #define appmenu    11
  #define empty_slot 12
  #define overstock  13
  #define flag       14
  #define replenish  15
  #define new_pick   16


  aadd (call_list, {menu        , {|a,b| do_menu         (a,@b)}})
  aadd (call_list, {screens     , {|a,b| do_screens      (a,@b)}}) 
  aadd (call_list, {errors      , {|a,b| do_errors       (a,@b)}}) 

  aadd (call_list, {appmenu     , {|a,b| do_appmenu      (a,@b)}})
  aadd (call_list, {empty_slot  , {|a,b| do_empty_slot   (a,@b)}}) 
  aadd (call_list, {overstock   , {|a,b| do_overstock    (a,@b)}}) 
  aadd (call_list, {flag        , {|a,b| do_flag         (a,@b)}})
  aadd (call_list, {replenish   , {|a,b| do_replenish    (a,@b)}}) 
  aadd (call_list, {new_pick    , {|a,b| do_new_pick     (a,@b)}}) 




  // and let RADIO BEACON take care of the rest.

  radio_beacon (call_list,param_line,udf_list)
return





// these are the function stubs that are available.

PROCEDURE Initialize_Transactions()
RETURN

PROCEDURE Background_Process()            
RETURN

PROCEDURE Terminate_Transactions()
RETURN                         









*******************************************************************
*    menu         MAIN MENU PROCESSING
*******************************************************************



FUNCTION do_menu (RFArray,RFState)


     // the BEGIN STATE command sets up a 'DO CASE' statement (and the
     // STATEs are translated to CASE statements).  LOOP and EXIT control
     // movement between states, as follows:

     // use LOOP to jump to another STATE without going out to the radio
     // use EXIT to go out to the radio




BEGIN STATE menu WITH selection          // 'selection' is defined as a
                                         // STATIC by this command.



     //////////////////////////////////////////////////
     //     initial menu 
     //////////////////////////////////////////////////

     STATE   0


          // handhelds have small and awkward keyboards. 
          //
          // we find that a friendly convention is to NOT require an
          // ENTER key if the expected field is 1 character (typically
          // menus and confirmations).


          set cursor off

          @ 1,1 SAY "DEMO "  GET selection PICTURE " " 
          @ 3,1 SAY "1- Log out"
          @ 4,1 SAY "2- Demo Screens"
          @ 5,1 SAY "3- Demo Errors"
          @ 6,1 SAY "4- Sample App"

          nextstate is 1
          exit

     //////////////////////////////////////////

     STATE  1                            // Process Initial Menu


          DO CASE
          CASE selection = "1"

               RF_Log ("LOGOUT")
               retstate                  // return to security screen


          CASE selection = "2"

               callstate {screens,0} nextstate is 0


          CASE selection = "3"

               callstate {errors,0} nextstate is 0


          CASE selection = "4"

               callstate {appmenu,0} nextstate is 0


          OTHERWISE
          ENDCASE

          nextstate is 0
          LOOP                      


ENDSTATE








*******************************************************************
*    screens         Demonstrate Sample Screens
*******************************************************************



FUNCTION do_screens (RFArray,RFState)



BEGIN STATE screens WITH m_yesno,m_packsize,m_npacks,m_product,m_entry,;
                         m_value,atrans,nindex,m_stored



     // demonstrate simplest entry case

     state 0

           set cursor on

           @ 1,1 SAY "Simple Entry"
           @ 2,1 SAY "Product: " GET m_product PICTURE "      "  ;
                                    OPTION FO_ENTER

           @ 4,1 SAY "Simplest case,"
           @ 5,1 SAY "no VALID or MSG"
           @ 6,1 SAY "clause, only one"
           @ 7,1 SAY "entry field."

           nextstate is 1   
           exit                      // exit sends us to radio from here!


      state 1                        


           // this state will validate the data from state 0, and either
           // return to the main menu (on an empty entry), return to
           // state 0 (on an invalid entry), or proceed to state 2 for 
           // processing.


           if empty(m_product)       // we use empty field to return
                retstate             // to higher menu.  this is friendlier
           endif                     // than using a function key.

                                     // NOTE: this will NOT go to the radio.



           if !(len(m_product) = 6)
                @ rf_maxrow(),1 SAY "* 6 CHRS REQ'D *"
                beep
                nextstate is 0    
                loop                 // do NOT go to radio yet
           endif



           nextstate is 2            // proceed to state 2 for processing.
           loop                      // do NOT go to radio yet






     // same entry screen, but with VALID and MSG clause.  note that
     // check for empty string must still be in next case.


      state 2

           @ 1,1 SAY "Entry with VALID"
           @ 2,1 SAY "Product: "                                           ;
                         GET m_product PICTURE "      "                    ;
                                       OPTION FO_ENTER                     ;
                                       VALID {|x| len(x)=6 .or. empty(x)}  ;
                                       MESSAGE "* 6 CHRS REQ'D *" 


           @ 4,1 SAY "Same entry with"
           @ 5,1 SAY "VALID and MSG"
           @ 6,1 SAY "clause."

           nextstate is 3       
           exit                      // go to radio...



      state 3             

           if empty(m_product)       // can't do this from a VALID
                retstate
           endif                     

           nextstate is 4           
           loop                      // do NOT go to radio





      state 4          

      // we can put multiple fields onto the screen, but we have to be
      // careful about the friendliness of the user interface.


                                    // note that the first SAY has an 
                                    // exit clause, which specifies that
                                    // an empty entry is to be treated
                                    // as an exit.       

                                    // it also has an OPTION clause that
                                    // turns on the scanner.  the standard
                                    // options are FO_SCANENABL, FO_ENTER,
                                    // FO_NUMERIC, and FO_HIDDEN.  you can
                                    // add them (eg: FO_NUMERIC + FO_ENTER).


           @ 1,1 SAY "Multi-Field"
           @ 2,1 SAY "Product :" GET m_product  PICTURE "      "     ;
                                    VALID {|x| len(x)=6}                ;
                                    MESSAGE "* 6 CHRS REQ'D *"          ;
                                    EXIT  {|x| empty(x)}                ;
                                    OPTION FO_SCANENABL + FO_ENTER

           @ 3,1 SAY "Packsize:" GET m_packsize PICTURE "   "        ;
                                    VALID {|x| val(x)>0}                ;
                                    MESSAGE "* VALID VALUE! *"          ;
                                    OPTION FO_ENTER

           @ 4,1 SAY "# Packs :" GET m_npacks  PICTURE "   "         ;
                                    VALID {|x| val(x)>0}                ;
                                    MESSAGE "* VALID VALUE! *"          ;
                                    OPTION FO_ENTER
           
           nextstate is 5
           exit





      state 5

           // the RF_LOG file is a standard facility that we include. we
           // STRONGLY recommend that you use it in your applications. 

           // it helps you debug your applications, then helps you 
           // track unexpected events in the warehouse, then helps you
           // measure the performance of the warehouse.  our practice is
           // to log every database change with log records.
           // 
           // the RADIO BEACON libraries will put 'ERROR' records into the
           // log.  look for them periodically.
           // 
           // our experience, you cannot put too much information into the
           // radio log.
           // 
           // the structure is simple:
           // 
           // 
           //   RF_Log (actcode,<sku>,<location>,<quantity>,<scaler>,      ;
           //                                  <ref1>,<ref2>,<ref3>) -> nil
           // 
           // Arguments
           //
           //    actcode    Transaction identifier, up to 8 characters long.  
           //    <sku>      Product, if any, that is being handled.
           //    <location> Location, if any, that is being affected.
           //    <quantity> Quantity of product under discussion (always positive).
           //    <scalar>   Flag showing how location is affected. 
           //    <ref1>     Reference fields for further information
           //    <ref2>
           //    <ref2>
           // 
           // 
           // By convention, the scalar is set:
           // 
           //  1 if product is being added to location        (eg: Receiving)
           // -1 if product is being depleted from location   (eg: Picking)
           //  0 if product is not being added or depleted    (eg: Cycle Count)
           // 
           // 


           RF_log ("DEMOSCRN",m_product,,val(m_packsize)*val(m_npacks),1,"Screen Demo")





           // the FO_ENTER key option is non-standard for XBASE programmers,
           // who are used to SET CONFIRM ON.  however, we find that data
           // entry on handheld terminals is sufficiently awkward that the
           // programmer wants control on a field-by-field basis.


           @ 1,1 SAY "Confirm Key"

           @ 2,1 SAY "Requires ENTER.."
           @ 3,1 SAY "Yes or No :" GET m_YesNo PICTURE " "     ;
                                      VALID {|x| x $ "YN" }       ;
                                      MESSAGE "* 'Y' or 'N' *"    ;
                                      OPTION FO_ENTER
 
           @ 5,1 SAY "No ENTER reqd.."  
           @ 6,1 SAY "(Default)"
           @ 7,1 SAY "Yes or No :" GET m_YesNo PICTURE " "     ;
                                      VALID {|x| x $ "YN" }       ;
                                      MESSAGE "* 'Y' or 'N' *"    

           nextstate is 6             // head out to radio (exit) and resume
           exit                       // at state 6 





      state 6

           // the SET CURSOR ON|OFF works as you would expect.

           set cursor on

           @ 1,1 SAY "Cursor Control"
           @ 2,1 SAY "Cursor ON.."
           @ 3,1 SAY "Product :" GET m_product PICTURE "      ";  
                                      VALID {|x| len(x)=6}        ;
                                      MESSAGE "* 6 CHRS REQ'D *"  ;
                                      OPTION FO_ENTER
           nextstate is 7
           exit


      state 7

           // little trick: we repaint the top half of the screen...
           // 

           @ 1,1 SAY "Cursor Control"
           @ 2,1 SAY "Cursor ON.."
           @ 3,1 SAY "Product :" + m_product


           // ... and add new text onto the bottom

           set cursor off

           @ 5,1 SAY "Cursor OFF.."
           @ 6,1 SAY "Yes or No :" GET m_YesNo PICTURE " "     ;
                                      VALID {|x| x $ "YN" }       ;
                                      MESSAGE "* 'Y' or 'N' *"    
           nextstate is 8
           exit







      state 8

           // the FO_NUMERIC key option uses the handheld's edit, and
           // can simplify error checking. 

           set cursor on

           @ 1,1 SAY "Numeric Only"

           @ 2,1 SAY "ALPHAs Allowed"
           @ 3,1 SAY "Product :" GET m_product PICTURE "      "  ;
                                      OPTION FO_ENTER

 
           @ 5,1 SAY "NUMERIC Only"  
           @ 6,1 SAY "Quantity:" GET m_npacks PICTURE "    "      ;
                                    OPTION FO_NUMERIC + FO_ENTER



           nextstate is 9
           exit




      state 9

           // the FO_SCANENABLE option 

           set cursor on

           @ 1,1 SAY "Enable Scanning"

           @ 2,1 SAY "Scanner Enable"
           @ 3,1 SAY "Product :" GET m_product PICTURE "      "  ;
                                      OPTION FO_SCANENABL + FO_ENTER

 
           @ 5,1 SAY "Keyboard Only"  
           @ 6,1 SAY "Quantity:" GET m_npacks PICTURE "    "      ;
                                    OPTION FO_ENTER



           nextstate is 20
           exit




      state 20 

           // as well, function keys are non-standard for programmers who
           // are used to SET KEY TO.  The problem is that one cannot easily
           // execute another routine from a state table. 

           @ 1,1 SAY "Function Keys" 
           @ 2,1 SAY "Entry :"        GET m_entry PICTURE "     "  ;
                                         VALID {|x| x $ "f1f2f3"}     ;           
                                         MESSAGE "* INVALID KEY *"    ;
                                         OPTION FO_ENTER

           @ 3,1 SAY "F1 to loop"
           @ 4,1 SAY "F2 to beep"
           @ 5,1 SAY "F3 to exit"

           // note: function keys don't require an ENTER.  even through
           // FO_ENTER is set, the function keys will return immediately.

           // they generate the value 'fn' - lowercase f, and n from 0 to 9.

           nextstate is 21
           exit



      state 21

           if m_entry = "f1"       
             @ 7,1 SAY "LOOP"
             nextstate is 20
             loop
           endif

           if m_entry = "f2"
             beep
             @ 7,1 SAY "BEEP"
             nextstate is 20
             loop
           endif

           // must be f3, so we exit

           nextstate is 25
           loop




           // implement a pick-list.  this function presents a screen-full
           // of options, and allows a pick from that list.  generally
           // these are records in a database, in which case the recno() 
           // of the specified record is available in the first field
           // of the array being displayed.

           // the pick-list is multi-page.  hitting ENTER will move to the
           // next page.  the current and last page numbers are displayed
           // in the top right corner.

           // required 'atrans' and 'nindex' to be defined as variables
           // in the BEGIN STATE statement

      state 25


          select password           // let's show list of possible users
          set order to 0

          // do a sweep across the file for possible user names


          // BUILD_MENU <array>, <while_cond>, <extract_string_expression>
          //
          //   creates <array> with structure [<extract_string>,recno()]

          goto top

                                    // rfconfig(10) is the default columns
                                    // on the handhelds. (less 2 to account
                                    // for the item numbering).

          BUILD_MENU atrans,(!eof()),(left(password->name,rfconfig(10)-2))
          nindex = 1

          if len(atrans) = 0        // check for no records...
            @ rf_maxrow(),1 SAY "* NO RECORDS*"
            beep
            nextstate is 30
            loop
          endif

          nextstate is 26
          loop


     STATE 26

          if nindex > LEN(atrans)        // restart on high value (must be 
               nextstate is 25           // ENTER at last page)
               loop
          endif

          @1,1 SAY "PICK LIST"        // NOTE: last 5 chars of this line
                                         // are used for <page n/m>



          // warning: do NOT use a 'MESSAGE' clause here (if you use a
          // valid), because the message will overlap with the last item
          // in the picklist.

          @2,1 SAY "Select User: " GET m_entry PICTURE " "    ;
                                                  OPTION FO_NUMERIC


          DRAW_MENU aTrans,nindex

          nextstate is 27
          exit


     STATE 27


          if len(m_entry) = 0
             nindex += rf_maxrow()-2    // add # of rows (less 2 for header)
             nextstate is 26
             loop
          endif


          IF m_entry == "0" .or. val(m_entry) = 0              ;
                            .or. val(m_entry) > rf_maxrow()-2  ;
                            .or. LEN(aTrans) <= nindex+val(m_entry)

               beep   // no msg, screen is quite full
               nextstate is 26
               loop
          endif


          // looks good

          select password
          goto aTrans[nindex+val(m_entry)-1,1]


          @ 1,1 SAY "Users" GET m_entry PICTURE " "

          @ 3,1 SAY "ID:  " +  password->id
          @ 4,1 SAY "Name:" +  left(password->name,11)
          @ 5,1 SAY "Pswd:" +  "xxxxxxxx"
          @ 6,1 SAY "Priv:" +  str(password->privilege,4)

          nextstate is 30
          exit





     // demonstrate concurrency.  you need at least two terminals (or
     // one terminal and the console) to try this.  each terminal has
     // its own value of 'm_stored'.  


     state 30 

           m_stored = ""
           nextstate is 31
           loop

     state 31

           @ 2,1 SAY "Value: " GET m_value PICTURE "      "      ;
                                    OPTION FO_ENTER                     ;
                                    VALID {|x| len(x)=6 .or. empty(x)}  ;
                                    EXIT  {|x| x="f1"}                  ;
                                    MESSAGE "* 6 CHRS REQ'D *" 


           @ 4,1 SAY "Last : " + m_stored

           @ 6,1 SAY "F1 to exit"

           nextstate is 32       
           exit                      // go to radio...


     state 32

           if m_value = "f1"
             retstate 
           endif

           if len(m_value) = 0
             nextstate is 31
             loop
           endif

           m_stored = m_value
           nextstate is 31
           loop





ENDSTATE







*******************************************************************
*    errors         Demonstrate Error Handling
*******************************************************************



FUNCTION do_errors (RFArray,RFState)



BEGIN STATE errors WITH m_choice


    // error recovery is critical to an RF system.  imagine 30 users
    // picking and cycle counting, and one user tries a new function
    // that you added last night.  kaboom...



    state 0

         @ 1,1 SAY "ERRORS " get m_choice picture " "

         @ 2,1 SAY "1- Program Error"
         @ 3,1 SAY "2- Overlap Error"
         @ 4,1 SAY "3- Loop Error 1"            
         @ 5,1 SAY "4- Loop Error 2"
         @ 6,1 SAY "5- GET Missing"
         @ 7,1 SAY "6- More Errors.."

         nextstate is 1
         exit



    state 1

         if len(m_choice) = 0       // empty select from state 0
           retstate                 // return to higher menu
         endif

         if m_choice $ ("12345")    // valid choice made in state 0
           nextstate is 2
           loop
         endif

         if m_choice <> "6"         // invalid choice (not MORE...) made
           beep                                                         
           nextstate is 0
           loop
         endif


         @ 1,1 SAY "ERRORS " GET m_choice PICTURE " " ;
                                  VALID {|x|x$"78" .or. empty(x)}

         @ 2,1 SAY "7- No SELECT"
         @ 3,1 SAY "8- FILTER Left"

         nextstate is 2
         exit




    state 2

         if len(m_choice) = 0      // empty select from state 1
           nextstate is 0
           exit
         endif


         do case

            case m_choice = "1"

                 // program errors might include using an uninitialized
                 // variable, or performing a incorrectly typed function.

                 // for example, val() expects a string.

                 val(0)


                 // never get here!



            case m_choice = "2"

                 // overlap errors are not as drastic a problem, but they
                 // are hard to detect at runtime, and should be weeded
                 // out at development time.

                 @ 1,1 SAY "Message 1"
                 @ 1,1 SAY "Message 2"    // overlaps Message 1


                 @ 2,1 SAY "Won't See This"   get m_choice picture " "
                 @ 3,1 SAY "At Console, but"
                 @ 4,1 SAY "Will Try to Send"
                 @ 5,1 SAY "To Radios."

                 nextstate is 0 
                 exit



            case m_choice = "3"

                 // loop errors sometimes happen because the SKIP is 
                 // missing, or does not check for eof().  an infinite 
                 // loop 'hangs' the system.

                 // if the loop does not access any RF library functions,
                 // does not change states, and does not SKIP, then we 
                 // are out of luck.

                 // here is an example of a loop that does not check for
                 // eof()

                 select password
                 set order to 1    // ID

                 seek "NOT FND"

                 do while password->ID <> "NOT FND" // oops, forgot about eof()

                   //...

                   skip
                 enddo

                 // will never get here!



            case m_choice = "4"

                 // sometimes loop errors happen because the state logic
                 // gets into an infinite loop.  

                 // you may accidentally loop to a non-existant state...

                 // you may forget to end a state with LOOP or EXIT...

                 // for example, if we LOOPed to state [errors,2], m_choice
                 // would still be set to "4" and we would try this code
                 // again.  like this...

                 nextstate is 2
                 loop

                 // will never get past here!




            case m_choice = "5"

                 // what does it mean if you go to the radio without
                 // a GET statement?  probably that you made an error
                 // in your state logic.  

                 // the watchdog will not catch it (transactions are 
                 // being processed quickly and smoothly), but you may
                 // create an infinite loop that grinds the RF bandwidth.

                 @ 1,1 SAY "SAYs Only"
                 @ 2,1 SAY "but no GETS"

                 nextstate is 0
                 exit




            case m_choice = "6"

                 // more choices

                 // should never get here... but if we are wrong, the
                 // system will not crash.



            case m_choice = "7"

                 // you MUST NOT assume that the active workspace that you
                 // left when you went to the radios is still valid!  other
                 // users may be working on the same files.

                 // the most common error is to fail to SELECT the workspace
                 // you need (usually if you remember to do that, then you
                 // will remember to seek to the right record).

                 // this error might not happen to a radio, but only to the
                 // console user.  to assist in debugging, each console
                 // transaction resets each workspace to BOF(), sets each
                 // workspace's active order to 0, and unselects the current
                 // active workspace.


                 set order to 1   // didn't select the workspace!
                 skip             // this won't work either

                 // never get here!


               case m_choice = "8" 

                 // if you forget to clear a filter or relation, other
                 // transactions may suffer...

                 // the system will check this for the console user only.

                 select password
                 set filter to password->ID=='NOT FND'

                 @ 2,1 SAY "Won't See This"   get m_choice picture " "
                 @ 3,1 SAY "At Console, but"
                 @ 4,1 SAY "Not Tested Here"
                 @ 5,1 SAY "For Speed. Note"
                 @ 6,1 SAY "Logon will fail"
                 @ 7,1 SAY "(Console Will"
                 @ 8,1 SAY "Clear Filter!)"

                 nextstate is 0
                 exit




            otherwise

                 beep
                 nextstate is 0
                 loop


         endcase


         // don't EVER put this line where it might be reached by accident !

         terminate ("This function turns down the radio system !")


     endstate










*******************************************************************
*    appmenu         DEMO APPLICATION MENU PROCESSING
*******************************************************************


#define PROD_DIGITS 10       // these define the length of the fields
#define HOME_DIGITS  9
#define BULK_DIGITS  9

#define display_lines  (rf_maxrow()-2)  // shorthand - menus
                                        // display n-2 times on
                                        // an n line screen


FUNCTION do_appmenu (RFArray,RFState)



BEGIN STATE appmenu WITH selection



     //////////////////////////////////////////////////
     //     initial menu for WSO WAREHOUSE
     //////////////////////////////////////////////////

     STATE   0

          @ 1,1 SAY "DEMO APP " GET selection PICTURE " "
          @ 2,1 SAY "1- Find Bulk " 
          @ 3,1 SAY "2- Putaway Bulk"
          @ 4,1 SAY "3- Replenish"           
          @ 5,1 SAY "4- Flag For Repl"
          @ 6,1 SAY "5- Add Pickslot"
          @ 7,1 SAY "6- Explain Demo"
          nextstate is 1
          EXIT

     //////////////////////////////////////////

     STATE  1                                    // Process Initial Menu

          DO CASE
          CASE empty(alltrim(selection))     // return to higher menu
               retstate

          CASE selection = "1"
               callstate {empty_slot,0} nextstate is 0

          CASE selection = "2"
               callstate {overstock,0}  nextstate is 0

          CASE selection = "3"
               callstate {replenish,0}  nextstate is 0       

          CASE selection = "4"
               callstate {flag,0}       nextstate is 0

          CASE selection = "5"
               callstate {new_pick,0}   nextstate is 0

          CASE selection = "6"
               nextstate is 2
               loop

          OTHERWISE
          ENDCASE

          nextstate is 0
          loop


     STATE 2

          @ 1,1 SAY "EXPLAIN F1-EXIT" GET selection PICTURE " "
          @ 2,1 SAY "This is a simple"
          @ 3,1 SAY "pallet locator."

          @ 5,1 SAY "It track loc's,"
          @ 6,1 SAY "but not qty's."

          nextstate is 3
          exit


     STATE 3

          if left(selection,1) = "f"     // was a function key
             nextstate is 0
             loop
          endif

          @ 1,1 SAY "EXPLAIN F1-EXIT" GET selection PICTURE " "
          @ 2,1 SAY "Use 'ADD PICK'"
          @ 3,1 SAY "for new prods," 
          @ 4,1 SAY "then store some"
          @ 5,1 SAY "away with"
          @ 6,1 SAY "'PUTAWAY'."

          nextstate is 4
          exit

     STATE 4

          if left(selection,1) = "f"     // was a function key
             nextstate is 0
             loop
          endif

          @ 1,1 SAY "EXPLAIN F1-EXIT" GET selection PICTURE " "
          @ 2,1 SAY "Walk pickline"
          @ 3,1 SAY "and scan empties" 
          @ 4,1 SAY "with 'FLAG' then"
          @ 5,1 SAY "letdown with "
          @ 6,1 SAY "'REPLENISH'."

          nextstate is 5
          exit

     STATE 5

          if left(selection,1) = "f"     // was a function key
             nextstate is 0
             loop
          endif

          @ 1,1 SAY "EXPLAIN F1-EXIT" GET selection PICTURE " "
          @ 2,1 SAY "Bulk locations"
          @ 3,1 SAY "are either empty" 
          @ 4,1 SAY "or not empty."

          nextstate is 0
          exit


ENDSTATE










*******************************************************************
*    empty         FOUND AN EMPTY HOME?  WHERE ELSE IS THERE STOCK?
*******************************************************************

FUNCTION do_empty_slot (RFArray,RFState)


BEGIN STATE empty WITH m_prod,m_desc,m_homeslot,RFTrans,lindex,selection,;
                       lineno,confirm,m_bin



     STATE 0      

          @ 1,1 SAY "FIND BULK STOCK" 
          @ 2,1 SAY "Scan Prod / Home" 
                                          // accept either a product
                                          // or the homeslot barcode.
                                          // the more scanning used, the
                                          // fewer errors!

          @ 3,1 SAY ">" GET m_prod PICTURE space(PROD_DIGITS) ;
                                      OPTION FO_SCANENABL + FO_ENTER


          nextstate is 1
          exit
     

     //////////////////////////////////////////////////
     //     have product, show desc and reserve slots
     //////////////////////////////////////////////////


     STATE 1

          if len(m_prod) = 0              // empty entry signals exit back
               retstate                   // to previous menu
          endif
     
          select product
          set order to 1
     
          seekexact (m_prod)

          if !(found())                   // if not found, then this may be 
                                          // a homeslot barcode, which is 
                                          // equivalent)

               if valid_location (m_prod)
                    set order to 3        // same file, different index
                    seekexact (m_prod)
               endif

          endif

          if !(found())
               @ rf_maxrow(),1 SAY "* NOT ON FILE *" 
               beep
               nextstate is 0  
               loop
          endif

          m_prod =     product->prodcode      // by saving these values
          m_desc =     product->descript      // in memory, you won't have
          m_homeslot = product->homeslot      // to reposition on the
                                              // product file to lookup 
                                              // these values again.

                                              // may not matter with a 5 
                                              // terminal system, critical
                                              // with a 50 terminal system!
          nextstate is 2
          loop



     STATE 2


          select overstoc
          set order to 1   // deleted()+prodcode

                  // in an RF system, you should NEVER perform a seek 
                  // that must skip deleted records - this can take
                  // many seconds.  (ie: do not 'SET DELETED ON').
                  // instead, add 'IIF(DELETED(),'T','F')' as a preface
                  // to your index expression.


          seekexact ("F"+m_prod)        // hit the reserve storage
          if !(found())    
               beep

               @ 5,1 SAY left(m_prod,16) 
               @ 6,1 SAY left(m_desc,16)
               @ 7,1 SAY iif (len(m_desc)>16,substr(m_desc,17,16),"")

               @ rf_maxrow(),1 SAY "* NO OVERSTOCK *"
               nextstate is 0
               loop
          endif


          // do a sweep across the locator to find all the matching
          // records.  they may be locked or deleted later, but...
          // BUILD_MENU is just a macro with the following form:
          //
          //        <tmparray> = {}                                        
          //        DO WHILE <srchexpr>                                    
          //              AAdd (<tmparray>, { RECNO(), <evalexpr>} )       
          //              SKIP                                             
          //        ENDDO


          BUILD_MENU RFTrans,(!eof().and. overstoc->prodcode = m_prod),;
                              overstoc->location
          lindex  = 1                        // points at first on screen


          nextstate is 12
          loop


     //////////////////////////////////////////////////
     //     put up a list of bins, and
     //     present options to the user
     //////////////////////////////////////////////////



      STATE 12                            // present options for OUT


          if lindex > len(RFtrans)               // then all done
               nextstate is 0
               loop
          endif



          @ 1,1 SAY m_prod
          @ 2,1 SAY "Select : " GET selection PICTURE " "

          DRAW_MENU RFTrans, lindex    

          nextstate is 13
          exit



          //////////////////////////////////////////////////
          //     if confirmed, then remove it
          //////////////////////////////////////////////////

          STATE 13

          if len(selection)=0                    // hit ENTER for more
               lindex += display_lines
               nextstate is 12
               loop
          endif

          if (val(selection) = 0 .OR. val(selection) > display_lines) .or. ;
                (len(RFTrans) < lindex+val(selection)-1)  // hit valid but not offered

               beep
               nextstate is 0
               loop
          endif

          * now have the record, lets get a clean pointer
          lindex = lindex + val(selection) - 1

          select overstoc       
          goto RFTrans[lindex,1]                       

          if deleted()
               @ rf_maxrow()-1,1 SAY "* NO LONGER *" GET confirm PICTURE " "
               @ rf_maxrow()  ,1 SAY "* AVAILABLE *"
               beep
               nextstate is 20
               exit
          endif

          @ 1,1 SAY left(m_prod,16)
          @ 2,1 SAY left(m_desc,16)
          @ 3,1 SAY iif (len(m_desc)>16,substr(m_desc,17,16),"")
          @ 4,1 SAY iif (len(m_desc)>32,substr(m_desc,33,16),"")

          @ 5,1 SAY "Loc: "+ overstoc->location
          @ 6,1 SAY "IS OVERSTOCK " 
          @ 7,1 SAY "LOCATION EMPTY?" GET confirm PICTURE " "                 ;
                                                     VALID {|x| x $ "YN" }       ;
                                                     MESSAGE "* 'Y' or 'N' *"    
          nextstate is 14
          exit


     //////////////////////////////////////////////////
     //     if confirmed, then remove it
     //////////////////////////////////////////////////

     STATE 14

     if confirm <> "Y"
          nextstate is 20
          loop
     endif

     select overstoc                  // although overstock was selected
                                      // in the previous state, who knows
                                      // what other RF transactions have
                                      // processed since then.
                                     
     goto RFTrans[lindex,1]           // similarly - we must not assume
                                      // that we will be at the same 
                                      // record as we were a few lines of
                                      // code above.

     record_lock                      // record_lock is a convenient
                                      // try-several times and abend
                                      // gracefully command. (also
                                      // see: record_add)
     delete
                                      // note: we do NOT bother to unlock
                                      // records - that would slow us
                                      // down here.  RADIO CLIPPER will 
                                      // take care of it in the 'idle'
                                      // time between RF transactions.

     RF_Log ("EMPTY",overstoc->prodcode,overstoc->location)

                                      // good programming practice is to
                                      // log every update with a comment.
                                      // debugging, reconsiling errors, and
                                      // productivity reports all flow from
                                      // a fully populated log. 

     @ rf_maxrow(),1 SAY "* MARKED EMPTY *"  
                                      // our convention is to use the last
                                      // line on the screen for comments.
                                      // since you will probably know what
                                      // kind of hardware you are using, 
                                      // you will probably use @ 8,1 ...

     nextstate is 20
     loop




     //////////////////////////////////////////////////
     //     now attempt to flag for replenishment
     //////////////////////////////////////////////////


     STATE 20 


     @ 1,1 SAY left(m_prod,16)
     @ 2,1 SAY left(m_desc,16)
     @ 3,1 SAY iif (len(m_desc)>16,substr(m_desc,17,16),"")
     @ 4,1 SAY iif (len(m_desc)>32,substr(m_desc,33,16),"")

     @ 6,1 SAY "FLAG REPLENISH?" GET confirm PICTURE " "                 ;
                                                VALID {|x| x $ "YN" }       

                                              // can't add message since
                                              // may have '* MARKED EMPTY *"
                                              // on screen!
     
     nextstate is 21
     exit

     //////////////////////////////////////////////////

     STATE 21

     if confirm <> "Y"
          nextstate is 0
          loop
     endif


     select product                 // scan homeslot to flag for letdown
     set order to 1  // prodcode  

     seekexact (m_prod) 

     if !(found())
           beep
           @ rf_maxrow(),1 SAY "* NOT ON FILE *"
           nextstate is 0
           loop
     endif

     @ 5,1 SAY left(product->prodcode,16)
     @ 6,1 SAY left(product->descript,16)
     @ 7,1 SAY iif (len(product->descript)>16,;
                                  substr(product->descript,17,16),"")


     if product->repl_reqd
          beep
          @ rf_maxrow(),1 SAY "* PREV FLAGGED *"
          nextstate is 0
          loop
     endif

     record_lock
     replace product->repl_reqd  with .t.
     replace product->lasttried  with ""      // date/time last tried

     RF_Log ("FLAG-FOR",m_prod,m_homeslot)
     @ rf_maxrow(),1 SAY "*   FLAGGED   *"

     nextstate is 0
     loop



     ENDSTATE









*******************************************************************
*    overstock         RESERVE STOCK FILL
*******************************************************************


FUNCTION do_overstock (RFArray,RFState)



BEGIN STATE overstock WITH m_prod,m_desc,m_homeslot,m_bin,selection,confirm


     STATE 0
     @ 1,1 SAY "PUTAWAY BULK"
     @ 2,1 SAY "SCAN PRODUCT:"
     @ 3,1 SAY ">" GET m_prod PICTURE space(PROD_DIGITS) ;
                                 OPTION FO_SCANENABL + FO_ENTER

     nextstate is 1
     exit


     //////////////////////////////////////////////////
     //     have product, show desc and reserve slots
     //////////////////////////////////////////////////

     STATE 1

     if len(m_prod) = 0
          retstate
          exit                                   // just bounce back
     endif

     select product 
     set order to 1

     seekexact (m_prod)


     if !(found()) .or. len(alltrim(product->homeslot)) = 0
          beep

          @ 5,1 SAY m_prod
          @ 6,1 SAY "Use ADD PICKSLOT" 
          @ 7,1 SAY "for new products"

          @ rf_maxrow(),1 SAY "* NOT ON FILE *" 

          nextstate is 0
          loop
     endif


     m_desc =    product->descript
     m_homeslot = product->homeslot

     nextstate is 2
     loop



     STATE 2


     @ 1,1 SAY left(m_prod,16)
     @ 2,1 SAY left(m_desc,16)
     @ 3,1 SAY iif (len(m_desc)>16,substr(m_desc,17,16),"")
     @ 4,1 SAY iif (len(m_desc)>32,substr(m_desc,33,16),"")

     @ 5,1 SAY "Home: "+m_homeslot

     @ 6,1 SAY "Bulk Putaway"
     @ 7,1 SAY "Locn: " GET m_bin PICTURE space(BULK_DIGITS);
                                     OPTION FO_SCANENABL + FO_ENTER


     nextstate is 3
     exit

     //////////////////////////////////////////////////
     //     get confirmation
     //////////////////////////////////////////////////


     STATE 3

     if empty(m_bin)                   // allow cancel with empty field
          nextstate is 0
          loop
     endif

     if !(valid_location (m_bin))
          @ rf_maxrow(),1 SAY "* INVALID BIN *"
          beep
          nextstate is 2
          loop
     endif



     @ 1,1 SAY left(m_prod,16)
     @ 2,1 SAY left(m_desc,16)
     @ 3,1 SAY iif (len(m_desc)>16,substr(m_desc,17,16),"")
     @ 5,1 SAY "Locn:" + m_bin

     @ 7,1 SAY "CONFIRM (Y/N):" GET confirm PICTURE " "                 ;
                                               VALID {|x| x $ "YN" }       ;
                                               MESSAGE "* 'Y' or 'N' *"   

     nextstate is 4
     exit


     //////////////////////////////////////////////////
     //     get confirmation of IN
     //////////////////////////////////////////////////


     STATE 4

     if confirm == "N"
          beep
          @ rf_maxrow(),1 SAY "* CANCELLED *"
          nextstate is 2
          loop
     endif

     // if receipts are not always full pallets, then it
     // might be useful to check whether this overstock location
     // already contains this product before adding a record.

     select overstoc 

     // quick check - if already this product in this bulk locn,
     // then no need to add

     set order to tag ovs-locn     // deleted() + locn
     seek ("T"+m_bin)
                                   // check every product already in
                                   // that bin
     do while (!(eof()) .and. overstoc->location = m_bin)
       if overstoc->prodcode = m_prod
         @ rf_maxrow(),1 SAY "* ADDED TO *"
         nextstate is 0
         loop
       endif
     enddo

     // would be more elegant to reuse an existing deleted() record
     // here (would eliminate need to repack file periodically).

     record_add            

     replace overstoc->prodcode     with m_prod
     replace overstoc->location     with m_bin

     @ rf_maxrow(),1 SAY "*  UPDATED  *"

     RF_Log ("OVERSTOC",m_prod,m_bin)

     nextstate is 0 
     loop



ENDSTATE









*******************************************************************
*    flag         FLAG FOR REPLENISHMENT
*******************************************************************

FUNCTION do_flag (RFArray,RFState)


    // this allows a supervisor to walk the pickslots and scan
    // the bins that he wants replenished.   

    // this is, of course, very simplistic.  if you add
    // perpetual inventory, then you can do this automatically.

    // even better; if you have access to the current orders 
    // (perhaps through a picking module), you can call for 'hot' 
    // letdown when the pickslot falls below the quantity required
    // to fill released orders.


BEGIN STATE flag WITH m_prod

     STATE 0              

     @ 1,1 SAY "FLAG REPLENISH"
     @ 2,1 SAY "SCAN # OR SLOT"
     @ 3,1 SAY ">" GET m_prod PICTURE space(PROD_DIGITS) ;
                                 OPTION FO_SCANENABL + FO_ENTER

     nextstate is 1
     exit


     //////////////////////////////////////////////////
     //     have product, show desc and reserve slots
     //////////////////////////////////////////////////

     STATE 1

     if empty(m_prod)
          retstate
     endif

     select product                 

     set order to 1   // prodcode
     seekexact (m_prod)

     if !(found())                   //if not found, then may be a slot barcode
          if valid_location(m_prod)
               set order to 3        // same file, different index
               seekexact (m_prod)    // lookup by homeslot address
          endif

     endif


     if !(found())
          beep
          @ rf_maxrow(),1 SAY "* NOT ON FILE *"
          nextstate is 0
          loop
     endif


     @ 5,1 SAY left(product->prodcode,16)
     @ 6,1 SAY left(product->descript,16)
     @ 7,1 SAY iif (len(product->descript)>16,;
                                  substr(product->descript,17,16),"")


     if product->repl_reqd
          beep
          @ rf_maxrow(),1 SAY "* PREV FLAGGED *"
          nextstate is 0
          loop
     endif


     record_lock
     replace product->repl_reqd with .t.       // request replenishment
     replace product->lasttried  with ""       // date/time last tried

     RF_Log ("FLAG-FOR",m_prod,product->homeslot)
     @ rf_maxrow(),1 SAY "*   FLAGGED   *"

     nextstate is 0
     loop



ENDSTATE







*******************************************************************
*    replenish         DIRECTED REPLENISHMENT
*******************************************************************

FUNCTION do_replenish (RFArray,RFState)



BEGIN STATE replenish  WITH m_prod,m_desc,m_homeslot,m_recno, RFTrans, lindex,;
                            lineno,confirm,selection


     STATE 0                          


     confirm = " "

     nextstate is 1
     loop


     //////////////////////////////

     STATE 1


     if left(confirm,1) = "f"                  // any function key
          retstate
     endif

     // the lasttried field allows multiple forklift drivers
     // to replenish the pickline, by dropping each request 
     // to the bottom of the queue when a driver views it.

     // the next driver would see a different request (unless it
     // was the last item, in which case the two drivers would
     // run into each other, just in time for a beer!)

     // an alternate technique is to use the rf_termid() value
     // to mark a record as belonging to a driver.  we do this
     // in less-than-pallet replenishments, where we want to 
     // mark several items for a single driver for a single trip.



     select product
     set order to 2         // repl_reqd + lasttried

     set softseek on
     seek ('T')                          // look for replenishment-requrired

     if eof() .or. !(product->repl_reqd)

          @ 1,1 SAY "REPLENISHMENT"
          @ 2,1 SAY "Nothing more..." GET confirm PICTURE " "

                                         // we use a get here to leave
                                         // the message on the screen
          nextstate is 20
          exit
     endif


     // ok, got a product that need replenishment.  timestamp it
     // to indicate that we have processed.

     m_recno = recno()                   // this is the record we are going
                                         // to work on for a while...

     record_lock
     replace product->lasttried with dtos(date()) + time()


     m_prod =     product->prodcode 
     m_desc =     product->descript
     m_homeslot = product->homeslot

     nextstate is 2
     loop


     /////////////////////////////////////////


     STATE 2

     select overstoc                  
     set order to 1   // deleted()+prodcode

     seekexact ("F"+m_prod)
     if !(found())                   

          // there is no overstock...

          select product              // erase the replenish request
          goto m_recno

          record_lock
          replace product->repl_reqd with .f.

          beep
          @ rf_maxrow(),1 SAY "* NO OVERSTOCK *"

          nextstate is 16
          loop

     endif

     // do a sweep across the locator to find all the matching
     // records.  they may be locked or deleted later, but...

     BUILD_MENU RFTrans,(!eof().and. overstoc->prodcode = m_prod),;
                              overstoc->location

     lindex  = 1                  // points at first on screen

     nextstate is 12
     loop


     //////////////////////////////////////////////////
     //     put up a list of bins, and
     //     present options to the user
     //////////////////////////////////////////////////


     STATE 12                                    // present options for OUT


          if lindex > len(RFtrans)               // then all done
               @ rf_maxrow(),1 SAY "* Skipped *"
               nextstate is 16
               loop
          endif


          @ 1,1 SAY m_prod
          @ 2,1 SAY "Exit-F1 Select:" GET selection PICTURE " "

          DRAW_MENU RFTrans, lindex    

     nextstate is 13
     exit

     //////////////////////////////////////////////////
     //     if confirmed, then remove it
     //////////////////////////////////////////////////

     STATE 13

          
          if left(selection,1) = "f"             // any function key
               retstate
          endif

          if len(selection)=0                    // hit ENTER for more
               lindex += display_lines
               nextstate is 12
               loop
          endif                     

          selection = VAL(selection)             // hit 0 or invalid to cancel 
          if selection = 0 .OR. selection > display_lines
               beep
               nextstate is 1
               loop
          endif
          if len(RFTrans) < lindex+selection-1   // hit valid but not offered
               beep
               nextstate is 12
               loop
          endif

          * now have the record, lets get a clean pointer
          lindex = lindex + selection - 1

          select overstoc
          goto RFTrans[lindex,1]                       

          if deleted()
               @ rf_maxrow()-1,1 SAY "* NO LONGER *"
               @ rf_maxrow()  ,1 SAY "* AVAILABLE *"
               beep
               nextstate is 16
               loop
          endif

          // one way or another, we have satisfied the replenish request

          select product            // erase the replenish request
          goto m_recno

          record_lock
          replace product->repl_reqd with .f.

          nextstate is 131
          loop



     STATE 131

          @ 1,1 SAY LEFT (m_prod,16)
          @ 2,1 SAY left(m_desc,16)
          @ 3,1 SAY iif (len(m_desc)>16,substr(m_desc,17,16),"")
          @ 4,1 SAY iif (len(m_desc)>32,substr(m_desc,33,16),"")

          @ 5,1 SAY "Loc: "+ overstoc->location
          @ 7,1 SAY "IS BIN EMPTY?" GET confirm PICTURE " "                 ;
                                                   VALID {|x| x $ "YN" }       ;
                                                   MESSAGE "* 'Y' or 'N' *"    

          nextstate is 14
          exit



     //////////////////////////////////////////////////
     //     if confirmed, then remove it
     //////////////////////////////////////////////////

     STATE 14

     if confirm <> "Y" .and. confirm <> "N"
        nextstate is 131
        loop
     endif

     if confirm == "Y"
          select overstoc
          goto RFTrans[lindex,1]                       

          record_lock

          DELETE

          RF_Log ("MARKEMPT",overstoc->prodcode,overstoc->location)
          @ rf_maxrow(),1 SAY "* MARKED EMPTY *"

     endif

     nextstate is 15
     loop



     //////////////////////////////////////////////////
     //     show that work was done
     //     15 if replenishment successful, else 16
     //////////////////////////////////////////////////

     STATE 15

     // nothing to do, but at one time this was required

     RF_Log ("REPLNIS",overstoc->prodcode,m_homeslot,0,0,overstoc->location)

     nextstate is 16
     loop

     //////////////////////////////////////////////////

     STATE 16


     @ 1,1 SAY "REPLENISHMENT"
     @ 2,1 SAY "Press ENTER" GET confirm PICTURE " "



     @ 3,1 SAY left(m_prod,16)
     @ 4,1 SAY left(m_desc,16)
     @ 5,1 SAY iif (len(m_desc)>16,substr(m_desc,17,16),"")      
     @ 6,1 SAY iif (len(m_desc)>32,substr(m_desc,33,16),"")

     @ 7,1 SAY "Pick:"+ m_homeslot

     nextstate is 1
     exit


     /////////////////////////////////////////////////



     STATE 20      // a dummy to allow the exit message to display

     retstate


ENDSTATE












*******************************************************************
*    new_pick         DEFINE A NEW PICK LOCATION
*******************************************************************


FUNCTION do_new_pick (RFArray,RFState)



BEGIN STATE new_pick WITH m_prod,m_desc,m_homeslot,m_new_pick,selection,;
                          confirm

     STATE 0

          @ 1,1 SAY "NEW PICK SLOT"
          @ 2,1 SAY "SCAN PRODUCT"
          @ 4,1 SAY ">" GET m_prod PICTURE space(PROD_DIGITS) ;
                                      OPTION FO_SCANENABL + FO_ENTER

          nextstate is 1
          exit
     


     //////////////////////////////////////////////////
     //     have product, show desc and reserve slots
     //////////////////////////////////////////////////


     STATE 1

          if len(m_prod) = 0
               retstate                               // just bounce back
          endif
     
          select product
          set order to 1
     
          seekexact (m_prod)                  

          m_homeslot = "NO SLOT"     
          m_desc     = "No description on file."  

          if !(found())
               beep
               @ rf_maxrow(),1 SAY "* NOT ON FILE *"
               nextstate is 4
               loop
          endif

          m_desc     = product->descript
          m_homeslot = product->homeslot

          nextstate is 2
          loop



     //////////////////////////////////////////////////
     //   ask if a new slot wanted  
     //////////////////////////////////////////////////


     STATE 2

          @ 1,1 SAY "NEW PICK SLOT"
          @ 2,1 SAY left(m_prod,16)          

          @ 3,1 SAY left(m_desc,16)
          @ 4,1 SAY iif (len(m_desc)>16,substr(m_desc,17,16),"")

          @ 5,1 SAY "Home: " + m_homeslot
          @ 6,1 SAY "Move Home?" GET confirm PICTURE " "                 ;
                                                VALID {|x| x $ "YN" }       ;
                                                MESSAGE "* 'Y' or 'N' *"    

          nextstate is 3
          exit                 



     //////////////////////////////////////////////////
     //   confirm whether new slot wanted
     //////////////////////////////////////////////////


     STATE 3

          if confirm == "N"
               @ rf_maxrow(),1 SAY "* CANCELLED *"
               nextstate is 0
               loop
          endif

          nextstate is 4
          loop

     //////////////////////////////////////////////////
     //   get the new scan slot  
     //////////////////////////////////////////////////


     STATE 4


          @ 1,1 SAY "NEW PICK SLOT"
          @ 2,1 SAY left(m_prod,16)
          @ 3,1 SAY left(m_desc,16)
          @ 4,1 SAY iif (len(m_desc)>16,substr(m_desc,17,16),"")

          @ 6,1 SAY "Scan New Home:" 
          @ 7,1 SAY ">" GET m_new_pick PICTURE space(HOME_DIGITS)  ;
                                          OPTION FO_SCANENABL + FO_ENTER


          nextstate is 5
          exit                 



     //////////////////////////////////////////////////
     //   delete the old, and record the new  
     //////////////////////////////////////////////////


     STATE 5


          if len(m_new_pick) = 0             
               beep
               @ rf_maxrow(),1 SAY "* CANCELLED *"
               nextstate is 0
               loop
          endif

          if !(valid_location (m_new_pick))
               @ rf_maxrow(),1 SAY "* INVALID BIN *"
               beep
               nextstate is 4
               loop
          endif


          // quick lookup - is this homeslot being used by something else?

          select product
          set order to 3                         //home

          seekexact (m_new_pick)
          if found()
               @ rf_maxrow(),1 SAY "* NOT EMPTY *"
               beep
               nextstate is 4
               loop
          endif

          // ok, now either update the existing product record, or
          // add a new one

          select product
          set order to 1
     
          seekexact (m_prod)

          if found()
               record_lock
          else
               record_add
               replace product->prodcode  with m_prod
               replace product->descript with m_desc
          endif

          replace product->homeslot with m_new_pick

          RF_Log ("newpick",m_prod,m_new_pick,0,0,"FROM: "+m_homeslot)       

          @ rf_maxrow(),1 SAY "* UPDATED *"
          nextstate is 0


ENDSTATE







// example of a UDF that might be used in a VALID clause 

function valid_location(location)

     // hmmm, well maybe we won't check too diligently

return (.t.)
