// This code is to explore the concept Printing from a Tbrowse.
// the Idea is pass the current tbrowse to a function and print a file
// using the existing Headers, (footers), column contents and the current
// index or subIndex.

// Les Squires [73020,3435] came up with the idea and I'm trying to 
// squeeze all information from the Tbrowse object.

// It's part of an ongoing discussion at the BCS and your 
// comments are very welcome.  Pat Tormey [72217,3014]

*********************   This is Just a setup thing ***********************
*********************                              ***********************
Function BCStbPrn()
 LOCAL oB, column, i, FIRST, LAST
 LOCAL cHead, bField,aFields:={}
 Local aContent:={}  // the Ready to Print Array
 Local cFile     // if you choose to pass a file
 setcolor("w/b")
 cls
     IF ! FILE( "TBNAMES.DBF" )
        MAKE_DBF()
     ENDIF

     USE TBNames

     IF ! FILE( "TBNAMES.NTX" )
        INDEX ON TbNames->last + TbNames->first TO TBNAMES
     ENDIF

     SET INDEX TO TBNAMES

     AADD(aFields, {"Last Name" , {||TBNames->Last}  } )
     AADD(aFields, {"First Name", {||TBNames->First} } )
     AADD(aFields, {"City"      , {||TBNames->City}  } )

   /* make new browse object */
   oB := TBrowseDB(0, 0,MaxRow(), MaxCol())

   /* default heading and column separators */
   oB:headSep := ""
   oB:colSep  := "  "
   oB:footSep := ""
   /* add a col}mn for each field in the current workarea */
   FOR i = 1 TO LEN(aFields)
      cHead  := aFields[i, 1]
      bField := aFields[i, 2]
      /* make the new column */
      column := TBColumnNew( cHead, bField )
      oB:addColumn(column)
   NEXT

   // We now have a Tbrowse Object full of Stuff
   // So call the printer function
   aContent:=Tb2Array(oB)
   Array2File(aContent,cFile)
   // with the Array converted to an ASCII file you can easliy print 
Return Nil

*****************+************************
Function Array2File(aArray,cFile)
  // Purpose- Make an ASCII file for Printing
  // cFile the File to Print
  Local nHandle:=0, i:=0, j:=0
  Local cLine:=''
  altd()
  iif(cFile=nil,cFile:="Print.tmp",'')  // just in case
  nHandle:=FCreate(cFile,0) // open with read write Access
                            // will overwrite existing File

  if nHandle=0
   @maxRow(),0 say "No File Handle Available"
   Quit
  Endif

  // Just Looping through the Array
   For I=1 to aLen(aArray)
    cLine:=''  // clear cLine Buffer
    For j=1 to aLen(aArray[i])
       cLine:=cLine+aArray[i,j]
    Next
    fwrite(nHandle,cLine+chr(13)+chr(10))  // line feed, return
   Next
   
  Fclose(nHandle)

Return Nil

****************  Real Work Being Done here **************************************
Function Tb2Array(oB)
 // Purpose Return An Array ready for Printing
 Local i:=0      // counter 
 Local cColumn:=""
 Local aContent:={}  // contents of the Tbrowse
 Local aRow:={}
 Local nRecord:=RecNo()

  // getting Column Headers  and footers if you like
    // first find column width
  For i=1 to Ob:colCount()
   // get the Column Width
   AADD(aRow,Len(X2Char(EVAL(ob:getColumn(i):Block())))) 
  Next

  // sometimes the Column title excedes the Data width
  For i=1 to Ob:colCount()   // make a row of column headers
   // center title Based on Column Width
   aRow[i]:=PadC(ob:getColumn(i):Heading(),aRow[i]) 
  Next
   AADD(aContent,aRow)     // add the row of headers to Array

 go top

 While ! Eof()
  aRow:={} // clear array
  For i=1 to Ob:colCount()
  // first Get the Tb Column, then get the Column's Block
  // evaluate it, then Convert it to a String, and add it to the Array
  AADD(aRow,X2Char(EVAL(ob:getColumn(i):Block())))  // getting cryptic Huh?
  Next
  AADD(aContent,aRow)     // add the row to the Contents array
  Skip
 EndDo

Return aContent

******************************************
Function X2Char(X)
 // convert everything to Character
 Local cX:=''
 Do Case      // only need to do this IF aIndex hasn't been made yet
  Case ValType(X)="C" 
    cX:=X
  Case ValType(X)="N"
    cX:=Str(X)
  Case ValType(X)="D"
    cX:=DTOC(X)
  Case ValType(X)="L"
    cX:=iif(X,'YES','NO ')
  Case ValType(X)="A"
    cX:="ARRAY!"
  Case ValType(X)="M"
    cX:="MEMO"
  Otherwise   // just in case
      cX:= STR(Recno())
  EndCase

Return cX


********************************************* Stolen from TbWhile.prg
  STATIC FUNCTION make_dbf
    LOCAL x, aData := {                                                              ;
     { "SHAEFER","KATHRYN","415 WEST CITRUS ROAD #150","LOS ANGELES","CA","90030" },;
     { "OLSON","JAMES","225 NORTH RANCH ROAD","LOS ANGELES","CA","90023"          },;
     { "KAYBEE","JOHN","123 SANDS ROAD","CAMARILLO","CA","93010"                  },;
     { "HERMAN","JIM","123 TOON PAGE ROAD","VENTURA","CA","93001"                 },;
     { "BURNS","FRANK","123 VIRGINA STREET","OXNARD","CA","93030"                 },;
     { "PIERCE","HAWKEYE","123 OLD TOWN ROAD","PORT MUGU","CA","93043"            },;
     { "MORGAN","JESSICA","123 FRONTAGE ROAD","CAMARILLO","CA","93010"            },;
     { "POTTER","ROBERT","123 FIR STREET","OXNARD","CA","93030"                   },;
     { "WORTH","MARY","123)1/2 JOHNSON DRIVE","OXNARD","CA","93033"               },;
     { "JOHNSON","SUSAN","123 QUEENS STREET","OXNARD","CA","93030"                },;
     { "SAMSON","SAM","215 MAIN STREET","OXNARD","CA","93030"                     },;
     { "NEWNAME","JAMES","215 MAIN STREET","LOS ANGELES","CA","90000"             },;
     { "OLEANDAR","JILL","425 FLORAL PARK DRIVE","FLORAL PARK","NY","10093"       },;
     { "SUGARMAN","CANDY","1541 SWEETHEART ROAD","HERSHEY","PA","10132"           } }



  DbCreate( "TBNAMES", { { "LAST ", "C", 18, 0, } ,;
                         { "FIRST", "C",  9, 0, } ,;
                         { "ADDR ", "C", 28, 0, } ,;
                         { "CITY ", "C", 21, 0, } ,;
                         { "STATE", "C",  2, 0, } ,;
                         { "ZIP  ", "C",  9, 0, } } )
  USE tbnames
  FOR x := 1 TO Len( aData )
     APPEND BLANK
     Aeval( aData[x], {|e,n| FieldPut( n, e ) } )
  NEXT
  USE
  RETURN NIL







