/*

 Ŀ
                                                                        
  File Name...: SCREEN.PRG                                              
  Author......: Vernon E. Six, Jr.                                      
  Date created: 07-26-94              Date updated: 07-26-94           
  Time created: 05:37:56pm            Time updated: 05:37:56pm         
  CopyRight...: (c) 1994 by FrontLine Software                          
                                                                        
 
  

*/

#include "box.ch"
#include "setcurs.ch"
#include "BAS_VERN.CH"


/* HYPERTEXT START
!short: basTitle()      Display a simple title screen
basTitle()      Display a simple title screen

^BDescription: ^B

   basTitle() displays a very simple title screen.


^BSyntax:^B

   basTitle( cMain, cSub )


^BPass:^B

   ^BcMain^B is a character expression that should contain the "main" title

   ^BcSub^B is a character expression that should contain the "sub" title


^BReturns:^B

   Always nil


^BSource:^B

   SCREEN.PRG

HYPERTEXT END */
function basTitle(pcMain,pcSub)

   local nLength := max( max(len(pcMain),len(pcSub)), 50 )
   local nLeft   := 40 - int( nLength / 2 )

   basNewScrn()

   basWind( 01,nLeft-2,05,nLeft+nLength+1,"","",5 )

   DispBox( 03,nLeft,03,nLeft+nLength-1,B_SINGLE )

   @ 02,nLeft say padc(pcMain,nLength)
   @ 04,nLeft say padc(pcSub ,nLength)

   return nil



/* HYPERTEXT START
!short: basMenu()       Draw and execute a simple menu
basMenu()       Draw and execute a simple menu

^BDescription: ^B

   basMenu() draws and executes a simple menu.


^BSyntax:^B

   basMenu( acChoices, cExit, @nChoice, [nSpacing] )


^BPass:^B

   ^BacChoices^B is an array with the following structure...

      { cChoice, ... }

      ^BcChoice^B is a character expression that should contain a menu
      item to draw on this menu.

   ^BcExit^B is a character expression that should contain the last choice
   for this menu.  In other words... You would probably think this should
   be the last element of ^BacChoices^B, but it is not.  This is a choice
   that is in addition to the choices listed in ^BacChoices^B.  The reason
   it's passed as a separate parameter is that it is display differently
   than those listed in ^BacChoices^B.

   ^B@nChoice^B is a numeric expression that must be passed by reference.
   ^BnChoice^B will be modified by basMenu() to tell you what choice the
   user selected.  The reason this value is passed by reference instead
   simply returned by basMenu() is so your users don't have to "re-walk"
   down the menu to their choice after returning from a sub-function.

   ^BnSpacing^B is a numeric expression that should contain the number of
   lines that each element of ^BacChoices^B should occupy.  The default is 2.

^BReturns:^B

   Always nil


^BSource:^B

   SCREEN.PRG


HYPERTEXT END */
function basMenu(pacChoices,pcExit,pnChoice,pnSpacing)

   local nLength  := len(pacChoices)
   local nLongest := len(pacChoices[1])
   local nI       := 0
   local nLeft    := 0
   local nLines   := 0
   local nTop     := 0
   local nBarLine := 0

   if valtype(pnSpacing) == "U"
      pnSpacing := 2
   endif

   nLines   := ( nLength * pnSpacing ) + (pnSpacing + 1)
   nTop     := 16 - (nLines/2)

   // find out which is the longest
   aEval(pacChoices,{|x| nLongest := max(nLongest,len(x)) })
   nLongest := max(40,nLongest)
   nLeft := 40 - int(nLongest/2)

   basWind(nTop-2,nLeft-2,nTop+nLines+1,nLeft+nLongest+1,"","",5)

   for nI := 1 to nLength
      @ nTop - (pnSpacing) + (nI*pnSpacing), nLeft prompt padc(pacChoices[nI],nLongest)
   next nI

   nBarLine := nTop + nLines - (pnSpacing+1)

   DispBox(nBarLine,nLeft,  nBarLine,nLeft + nLongest - 1, B_SINGLE )

   @ nTop + nLines - 1,nLeft prompt padc(pcExit,nLongest)

   menu to pnChoice

   return pnChoice







/* HYPERTEXT START
!short: basStat()       Draw a simple "status" message window
basStat()       Draw a simple "status" message window

^BDescription: ^B

   basStat() allows you to quickly tell the user something and proceed on
   with your program.  This is useful for displaying messages while
   performing some complex calculation, etc.

^BSyntax:^B

   basStat( [cStat] )


^BPass:^B

   ^BcStat^B is an optional character expression that should contain the
   text of the status message you want to display to the user.  If you don't
   pass ^BcStat^B, basStat() will remove the previous status message window.


^BReturns:^B

   Always nil


^BSource:^B

   SCREEN.PRG


HYPERTEXT END */
function basStat( pcText )

   if pcount() > 0

      basSaveScrn()

      SetCursor(SC_NONE)

      basWind(10,10,14,70,"","",1)

      @ 12,12 say padc(pcText,57)

   else

      basRestScrn()

   endif

   return nil



/* HYPERTEXT START
!short: basCursor()     Toggle/Set the cursor size and insert mode
basCursor()     Toggle/Set the cursor size and insert mode

^BDescription: ^B

   basCursor() allows you to toggle both the cursor size and the insert
   mode.


^BSyntax:^B

   basCursor( [lToggle] )


^BPass:^B

   ^BlToggle^B is a logical expression that should be set to TRUE if you
   want basCursor() to change to the opposite "insert" mode.  If you set
   ^BlToggle^B to FALSE, basCursor() will just set the cursor size to the
   appropiate size.  The default is TRUE if you don't pass ^BlToggle^B.


^BReturns:^B

   Always nil


^BSource:^B

   SCREEN.PRG


HYPERTEXT END */
function basCursor(plToggle)

   assume plToggle is .t. if missing

   if plToggle
      Set( _SET_INSERT, !Set(_SET_INSERT) )
   endif

   if Set( _SET_INSERT )
      SetCursor( SC_SPECIAL1 )
   else
      SetCursor( SC_INSERT )
   endif

   return nil












