/*

 Ŀ
                                                                        
  File Name...: SCROLL.PRG                                              
  Author......: Vernon E. Six, Jr.                                      
  Date created: 08-28-94              Date updated: 08-28-94           
  Time created: 01:28:45pm            Time updated: 01:28:45pm         
  CopyRight...: (c) 1994 by FrontLine Software                          
                                                                        
 
  

*/

#include "BAS_VERN.CH"

static slLogMsgs := .t.


/* HYPERTEXT START
!short: basScrollLog()  Get/Set the basScroll() logging mode
basScrollLog()  Get/Set the basScroll() logging mode

^BDescription: ^B

   basScrollLog() allows you to get/set the basScroll() log mode.


^BSyntax:^B

   lOrigMode := basScrollLog( [lNewMode] )


^BPass:^B

   ^BlNewMode^B is an optional logical expression that should be set to TRUE
   if you want basScroll() to log messages to the log file via basPostLog(),
   otherwise this value should be set to FALSE.  The original value is TRUE.
   If you don't pass ^BlNewMode^B, the mode is not changed.


^BReturns:^B

   ^BlOrigMode^B is a logical expression that will be set to TRUE if
   basScroll() is set to log messages to the log file via basPostLog(),
   otherwise this value will be FALSE.


^BSource:^B

   SCROLL.PRG

HYPERTEXT END */
function basScrollLog(plLogMsgs)

   local lOld := slLogMsgs

   if pcount() > 0
      slLogMsgs := plLogMsgs
   endif

   return plLogMsgs






/* HYPERTEXT START
!short: basScroll()     Display a list of scrolling status messages
basScroll()     Display a list of scrolling status messages

^BDescription: ^B

   basScroll() allows you to display status messages to the user with
   overwriting the previous status message.  The previous status message
   is simply "scrolled" up the screen.

   Depending on the setting of basScrollLog(), basScroll will also post
   these status message in the progress log file via basPostLog().


^BSyntax:^B

   Mode #1:

      basScroll()


   Mode #2:

      basScroll( cTitle, cFooter )


   Mode #3:

      basScroll( cText )


^BPass:^B

   Mode #1:

      Causes basScroll() to remove the scroll window from the screen.


   Mode #2:

      ^BcTitle^B is a character expression that should contain the title for
      the scroll window.

      ^BcFooter^B is a character expression that should contain the footer
      for the scroll window.


   Mode #3:

      ^BcText^B is a character expression that should contain the text of
      the message you want to display/log.


^BReturns:^B

   Always nil


^BSource:^B

   SCROLL.PRG


HYPERTEXT END */
function basScroll( pcText, pcFootNote )

   assume pcFootNote is "" if missing

   do case

      case pcount() == 0
         basRestScrn()

      case pcount() == 1
         scroll( 6,6,19,72,1 )
         @ 19,06 say padr(pcText,67)

         if slLogMsgs
            basPostLog(pcText)
         endif

      case pcount() == 2
         basSaveScrn()
         basWind( 5, 4, 20, 74, pcText, pcFootNote, 5 )

   endcase

   return nil

