/*

  Program Ŀ
                                                                        
  File Name...: PROPER.PRG                                              
  Author......: Vernon E. Six, Jr.                                      
  Date created: 03-13-94              Date updated: 07-31-94           
  Time created: 09:48:46pm            Time updated: 00:51:16am         
  CopyRight...: (c) 1994 by FrontLine Software                          
                                                                        
 
  

*/

// convert string to lower case, except first letter
/* HYPERTEXT START
!short: basProper()     Convert a string to lower case, except first letter
basProper()     Convert a string to lower case, except first letter

^BDescription: ^B

   basProper() converts a string "proper" case.  ie: all lower case except
   the first character which will be upper case.


^BSyntax:^B

   cProper := basProper( cInput )


^BPass:^B

   ^BcInput^B is a character expression that should contain the sting you
   want to convert to "proper" case.


^BReturns:^B

   ^BcProper^B is a character expression that will contain the "proper"
   version of ^BcInput^B.


^BSource:^B

   PROPER.PRG


HYPERTEXT END */
function basProper(pcInput)

   local cRetVal := ""
   local cTemp1  := ""
   local cTemp2  := ""

   cRetVal := ""

   if empty(pcInput)
      return ("")
   endif

   cTemp1 := upper(substr(pcInput,1,1))
   cTemp2 := lower(pcInput)

   if len(cTemp2) > 0
      cRetVal := cTemp1 + right(cTemp2,len(cTemp2)-1)
   endif

   return cRetVal


