#Include "Box.ch"
#Include "Inkey.ch"

// BaseBrowse Class is the Base tBrowse Class
// BrowseKeys Class has a default keystroke handler


Procedure TestBrowse
  Local oBrowse,oColumn
  Local nKey := 0,nCounter
  Local nChoice
  Use \source\oodles\sample\rrcust new

  Cls                                            // {NoIndent}
  SetColor("W+/B,W+/R")
  oBrowse := BrowseLite():NewDB(1,3,15,55)

  oBrowse:FootSep := ""  // Don't want default foot seperator

  For nCounter := 1 to FCount()
    oColumn := TBColumnNew(FieldName(nCounter),;
      FieldBlock(FieldName(nCounter)))
    oBrowse:AddColumn(oColumn)
  Next
  oBrowse:freeze  := 1         // Freeze the first column
  oBrowse:Display()          // Display the browse box
  Do While nKey != K_ESC
    oBrowse:ForceStable()      // display the browse rows
    nKey := Inkey(0)

    Do Case
      Case nKey == K_F2        // Change to monochrome
        oBrowse:ColorSpec := "W/N,N/W"
        oBrowse:Configure()
      Case nKey == K_F3        // Change the color
        oBrowse:ColorSpec := "W+/B,W+/R"
        oBrowse:Configure()
      Case nKey == K_LEFT     // handle the left key
        If oBrowse:ColPos > 2
          oBrowse:Left()
        Endif
      Otherwise
        oBrowse:DefaultKey(nKey)
    EndCase
  Enddo
  oBrowse:Kill()            // hide the browse
  Use
Return
