/**************************************************************************
  This class inherits from our browbox tbrowse class. It adds a highlight
  line that fills the full width of the browse window. This replaces
  the standard tbrowse hilite and dehilite methods.
 **************************************************************************/
#Include "oops.ch"
#Include "Box.ch"
#Include "Common.ch"

Static aColors := {{"N",0},{"B",1},{"G",2},{"BG",3},{"R",4},;
                 {"RB",5},{"GR",6},{"W",7},{"N+",8},;
                 {"B+",9},{"G+",10},{"BG+",11},{"R+",12},;
                 {"RB+",13},{"GR+",14},{"W+",15}}


Class BrowseLite Inherit BrowseBox
  Var HiliteLine       // Hiliteline of normal hilite field
  Var HiliteAttr       // The Hilite attribute Number
  Var NormAttr         // The Normal attribute Number

  Message Hilite()                 // overload Hilite
  Message DeHilite()               // overload DeHilite
  Message ForceStable()            // overload ForceStable
  Message Stabilize()              // overload Stabilize
  Message NewDB(t,l,b,r,nLineType) // overload constructor
  Message New(t,l,b,r,nLineType)   // overload constructor
  Message _COLORSPEC    ;          // overload assignment
     Action { |oB,_1| ;  // reset instance vars
          ob:HiliteAttr := oB:NormAttr := NIL,;
          oB:o:_COLORSPEC(_1)   }

End Class

Method NewDB(t,l,b,r,nLineType)
  ::Super():NewDB(t+1,l+1,b-1,r-1)
  ::HiliteLine := .T.  // default want a hilite line
Return (Self)

Method New(t,l,b,r,nLineType)
  ::Super():New(t+1,l+1,b-1,r-1)
  ::HiliteLine := .T.  // default want a hilite line
Return (Self)

Method ForceStable()
  Local IsAutolite := ::AutoLite
  If ::HiliteLine
    If IsAutoLite
      ::DeHilite()
      ::Autolite := .f.
    Endif
    ::Super():ForceStable()
    If IsAutoLite
      ::Autolite := .t.
      ::Hilite()
    Endif
  Else
    ::Super():ForceStable()
  Endif
Return (Self)

Method Stabilize()
  Local IsAutolite := ::AutoLite
  Local lReturn
  If ::HiliteLine
    If IsAutolite
      ::DeHilite()
      ::Autolite := .f.
    Endif
    lReturn := ::Super():Stabilize()
    If IsAutoLite
      ::Autolite := .t.
      ::Hilite()
    Endif
  Else
    lReturn := ::Super():Stabilize()
  Endif
Return (lReturn)

Method Hilite()
  Local cColor,cFor,cBack
  Local nStart,nEnd,nFor,nBack

  If ::HiliteLine
    If ::HiliteAttr == NIL
      nStart := At(",",::ColorSpec)+1
      nEnd   := At(",",Substr(::Colorspec,nStart))-1
      If nEnd < 1
        nEnd := Len(::ColorSpec)
      Endif
      cColor := Substr(::ColorSpec,nStart,nEnd)
      cFor   := Substr(cColor,1,At("/",cColor)-1)
      cBack  := Substr(cColor,(At("/",cColor)+1))
      nFor   := Ascan(aColors,{|a|a[1] == cFor })
      nBack  := Ascan(aColors,{|a|a[1] == cBack })
      ::HiliteAttr := aColors[nFor,2] + aColors[nBack,2] * 16
    Endif
    RestScreen( Row(),::nLeft,Row(),::nRight,;
      Transform( SaveScreen(Row(),::nLeft,Row(),::nRight),;
      Replicate("X"+chr(::HiliteAttr), ::nRight - ::nLeft + 1 ) ) )
  Else
    ::Super():Hilite()
  Endif

Return (Self)

Method DeHilite()
  Local cColor,cFor,cBack
  Local nStart,nEnd,nFor,nBack

  If ::HiliteLine
    If ::NormAttr == NIL
      nStart := 1
      nEnd := At(",",::ColorSpec)-1
      cColor := Substr(::ColorSpec,nStart,nEnd)
      cFor   := Substr(cColor,1,At("/",cColor)-1)
      cBack  := Substr(cColor,(At("/",cColor)+1))
      nFor   := Ascan(aColors,{|a|a[1] == cFor })
      nBack  := Ascan(aColors,{|a|a[1] == cBack })
      ::NormAttr := aColors[nFor,2] + aColors[nBack,2] * 16
    Endif
    RestScreen( Row(),::nLeft,Row(),::nRight,;
      Transform( SaveScreen(Row(),::nLeft,Row(),::nRight),;
      Replicate("X"+chr(::NormAttr), ::nRight - ::nLeft + 1 ) ) )
  Else
    ::Super():DeHilite()
  Endif
Return Self

// end of class definition
