/**************************************************************************
  This class inherits from our browkeys tbrowse class. It adds default
  border, header and footer lines.  It will also save the browse area
  and a BrowKill method will restore the screen at the end of the browse
 **************************************************************************/
#Include "oops.ch"
#Include "Box.ch"
#Include "Common.ch"

Class BrowseBox Inherit BrowseKeys
  Var BrowseArea                  // the savescreen var
  Var BoxType                     // What type of box
  Message NewDB(t,l,b,r,nLineType)// Overload constructor
  Message New(t,l,b,r,nLineType)  // Overload constructor
  Message Display()               // Display the Box
  Message Kill()                  // Hide the TBrowse
  Message Configure()             // Overload configure
End Class

Method NewDB(t,l,b,r,nLineType)
  ::Super():NewDB(t+1,l+1,b-1,r-1)
  Default nLineType To 1
  ::BrowseArea := SaveScreen(t,l,b,r)
  ::BoxType := nLineType
  Do Case
    Case nLineType == 1
      ::HeadSep := ""
      ::ColSep  := " "
      ::FootSep := ""
    Case nLineType == 2
      ::HeadSep := ""
      ::ColSep  := " "
      ::FootSep := ""
  EndCase
Return (Self)

Method New(t,l,b,r,nLineType)
  ::Super():New(t+1,l+1,b-1,r-1)
  Default nLineType To 1
  ::BrowseArea := SaveScreen(t,l,b,r)
  ::BoxType := nLineType
  Do Case
    Case nLineType == 1
      ::HeadSep := ""
      ::ColSep  := " "
      ::FootSep := ""
    Case nLineType == 2
      ::HeadSep := ""
      ::ColSep  := " "
      ::FootSep := ""
  EndCase
Return (Self)

Method Display()
  Do Case
    Case ::BoxType == 1
      DispBox(::nTop-1,::nLeft-1,::nBottom+1,::nRight+1,;
              B_DOUBLE,::ColorSpec)
    Case ::BoxType == 2
      DispBox(::nTop-1,::nLeft-1,::nBottom+1,::nRight+1,;
              B_SINGLE,::ColorSpec)
  End Case
Return Self


Method Configure()
  Do Case
    Case ::BoxType == 1
      DispBox(::nTop-1,::nLeft-1,::nBottom+1,::nRight+1,;
              B_DOUBLE,::ColorSpec)
    Case ::BoxType == 2
      DispBox(::nTop-1,::nLeft-1,::nBottom+1,::nRight+1,;
              B_SINGLE,::ColorSpec)
  End Case
  ::Super():Configure()
Return Self

Method Kill()
  RestScreen(::nTop-1,::nLeft-1,::nBottom+1,::nRight+1,::BrowseArea)
Return (Self)

// end of class definition
