/*************************************************************************
 This Class forms a container for tBrowse.  With this
 container class you can now 'inherit' from tbrowse. This
 class contains the tbrowse class with methods that maps
 directly onto those of tbrowse.
 Note the set of 'assignment and retrievel messages
 for the tbrowse instance varaibles
 *************************************************************************/
#include "oops.ch"

Class BaseBrowse
   Var o            // The container for the tBrowse Object


   // Constructor Messages
   Message NewDB(t,l,b,r)       // Same as TBrowseDB()
   Message New(t,l,b,r)         // Same as TBrowseNew()

   // Internal Instance Variable Assignment Messages
   Message _Autolite     Action{|oB,_1|oB:o:_Autolite(_1)    }
   Message _Cargo        Action{|oB,_1|oB:o:_Cargo(_1)       }
   Message _Colcount     Action{|oB,_1|oB:o:_Colcount(_1)    }
   Message _Colorspec    Action{|oB,_1|oB:o:_Colorspec(_1)   }
   Message _Colpos       Action{|oB,_1|oB:o:_Colpos(_1)      }
   Message _Colsep       Action{|oB,_1|oB:o:_Colsep(_1)      }
   Message _Footsep      Action{|oB,_1|oB:o:_Footsep(_1)     }
   Message _Freeze       Action{|oB,_1|oB:o:_Freeze(_1)      }
   Message _Gobottombloc Action{|oB,_1|oB:o:_Gobottomb(_1)   }
   Message _Gotopblock   Action{|oB,_1|oB:o:_Gotopbloc(_1)   }
   Message _Headsep      Action{|oB,_1|oB:o:_Headsep(_1)     }
   Message _Hitbottom    Action{|oB,_1|oB:o:_Hitbottom(_1)   }
   Message _Hittop       Action{|oB,_1|oB:o:_Hittop(_1)      }
   Message _Leftvisible  Action{|oB,_1|oB:o:_Leftvisible(_1) }
   Message _Nbottom      Action{|oB,_1|oB:o:_Nbottom(_1)     }
   Message _Nleft        Action{|oB,_1|oB:o:_Nleft(_1)       }
   Message _Nright       Action{|oB,_1|oB:o:_Nright(_1)      }
   Message _Ntop         Action{|oB,_1|oB:o:_Ntop(_1)        }
   Message _Rightvisible Action{|oB,_1|oB:o:_Rightvisible(_1)}
   Message _Rowcount     Action{|oB,_1|oB:o:_Rowcount(_1)    }
   Message _Rowpos       Action{|oB,_1|oB:o:_Rowpos(_1)      }
   Message _Skipblock    Action{|oB,_1|oB:o:_Skipblock(_1)   }
   Message _Stable       Action{|oB,_1|oB:o:_Stable(_1)      }

   // Internal Instance Variable Retrieval Messages
   Message Autolite      Action{|oB|oB:o:Autolite( )    }
   Message Cargo         Action{|oB|oB:o:Cargo( )       }
   Message Colcount      Action{|oB|oB:o:Colcount( )    }
   Message Colorspec     Action{|oB|oB:o:Colorspec( )   }
   Message Colpos        Action{|oB|oB:o:Colpos( )      }
   Message Colsep        Action{|oB|oB:o:Colsep( )      }
   Message Footsep       Action{|oB|oB:o:Footsep( )     }
   Message Freeze        Action{|oB|oB:o:Freeze( )      }
   Message Gobottomblock Action{|oB|oB:o:Gobottombl( )  }
   Message Gotopblock    Action{|oB|oB:o:Gotopblock( )  }
   Message Headsep       Action{|oB|oB:o:Headsep( )     }
   Message Hitbottom     Action{|oB|oB:o:Hitbottom( )   }
   Message Hittop        Action{|oB|oB:o:Hittop( )      }
   Message Leftvisible   Action{|oB|oB:o:Leftvisible( ) }
   Message Nbottom       Action{|oB|oB:o:Nbottom( )     }
   Message Nleft         Action{|oB|oB:o:Nleft( )       }
   Message Nright        Action{|oB|oB:o:Nright( )      }
   Message Ntop          Action{|oB|oB:o:Ntop( )        }
   Message Rightvisible  Action{|oB|oB:o:Rightvisible( )}
   Message Rowcount      Action{|oB|oB:o:Rowcount( )    }
   Message Rowpos        Action{|oB|oB:o:Rowpos( )      }
   Message Skipblock     Action{|oB|oB:o:Skipblock( )   }
   Message Stable        Action{|oB|oB:o:Stable( )      }

   // Cursor movement messages
   Message down()     Action {|oB| oB:o:down()      }
   Message end()      Action {|oB| oB:o:end()       }
   Message goBottom() Action {|oB| oB:o:goBottom()  }
   Message goTop()    Action {|oB| oB:o:goTop()     }
   Message home()     Action {|oB| oB:o:home()      }
   Message left()     Action {|oB| oB:o:Left()      }
   Message pageDown() Action {|oB| oB:o:pageDown()  }
   Message pageUp()   Action {|oB| oB:o:pageUp()    }
   Message panEnd()   Action {|oB| oB:o:panEnd()    }
   Message panHome()  Action {|oB| oB:o:panHome()   }
   Message panLeft()  Action {|oB| oB:o:panLeft()   }
   Message panRight() Action {|oB| oB:o:panRight()  }
   Message right()    Action {|oB| oB:o:right()     }
   Message up()       Action {|oB| oB:o:up()        }

   //  Miscellaneous Messages
   Message AddColumn(cName,bBlock)   ;
    Action {|oB,cName,bBlock| oB:o:AddColumn(cName,bBlock) }
   Message ColorRect(aRect,aColors)  ;
    Action {|oB,aRect,aColors|oB:o:ColorRect(aRect,aColors)  }
   Message ColWidth(nColumn)         ;
    Action {|oB,nColumn| oB:o:ColWidth(nColumn) }
   Message Configure()               ;
    Action {|oB| oB:o:Configure() }
   Message DeHilite()                ;
    Action {|oB| oB:o:DeHilite() }
   Message DelColumn(nPos)           ;
    Action {|oB,nPos| oB:o:DelColumn(nPos) }
   Message ForceStable()             ;
    Action {|oB| oB:o:ForceStable() }
   Message GetColumn(nColumn)        ;
    Action {|oB,nColumn| oB:o:GetColumn(nColumn)  }
   Message Hilite()                  ;
    Action {|oB| oB:o:Hilite() }
   Message InsColumn(nPos,oColumn)   ;
    Action {|oB,nPos,oColumn| oB:o:InsColumn(nPos,oColumn) }
   Message Invalidate()              ;
    Action {|oB| oB:o:Invalidate()  }
   Message RefreshAll()              ;
    Action {|oB| oB:o:RefreshAll() }
   Message RefreshCurrent()          ;
    Action {|oB| oB:o:RefreshCurrent() }
   Message SetColumn(nColumn,oColumn) ;
    Action {|oB,nColumn,oColumn| oB:o:SetColumn(nColumn,oColumn) }
   Message Stabilize()                ;
    Action {|oB| oB:o:Stabilize() }


End Class

// Constructor Method
Method NewDB(t,l,b,r)
  ::o := TBrowseDB(t,l,b,r)
return self

// Construcor Method
Method New(t,l,b,r)
  ::o := TBrowseNew(t,l,b,r)
return self

// EOF: Base Browse Class
