*:*********************************************************************
*:
*:      Program: BASCSTAT.PRG
*:
*:       System: Basic Statistics Compilation System
*:       Author: Lee Correll
*:    Copyright (c) 1987, Lee Correll
*:
*:        Calls: CHARACTER--procedure
*:             : NUMERIC--procedure
*:             : DISPLINE--procedure
*:             : AVERAGE--procedure
*:             : MODE1--procedure
*:             : MEDIAN--procedure
*:             : STDEV--procedure
*:
*:         Uses: STRUCTURE.DBF
*:
*: Documented: 3/1/87       1:00                   SNAP! version 1.72
*:*********************************************************************
CLEAR
PUBLIC fn,nr,na,nb,nc,nd,ne,nf,high
PUBLIC ft,avg,omde,medn,stddev
PUBLIC valid
SET STATUS OFF
SET ECHO OFF
SET EXACT ON
SET TALK OFF
SET CATALOG OFF
SET SAFETY OFF
SET PROCEDURE TO bascstat.xtr
fn    = SPACE(15)
fin   = SPACE(15)
ft    = SPACE(10)
high  = 0
nr    = 0
na    = 0
nb    = 0
nc    = 0 
nd    = 0
ne    = 0
nf    = 0
avg   = 0
fin   = TRIM(UPPER(DBF()))
?"Copying Structure of "+fin+" to STRUCTURE.DBF"
COPY STRUCTURE EXTENDED TO structure.dbf
SELECT 2
USE structure.dbf
GO TOP
SELECT 1 
GO TOP
SELECT 2
DO WHILE .NOT. EOF()
	IF RIGHT(TRIM(field_name),1) = "_" THEN
		SKIP
		LOOP
	ENDIF
	na = 0
	nb = 0
	nc = 0
	nd = 0
	ne = 0
	nf = 0
	ft = ""
	?
	?"Tabulating "+TRIM(field_name)
	?
	DO CASE
	CASE field_type = "C"
		DO character
		ft = "Character"
	CASE field_type = "N"
		DO numeric
		ft = "Numeric"
	OTHERWISE
		LOOP
	ENDCASE
	RECS  = RECCOUNT()
	valid = na + nb + nc + nd + ne + nf
	invalid = RECS - valid
	cumfreq = 0
	?"Printing"
	SET DEVICE TO PRINT
	@ 01,01 SAY "Filename  : "+fin           
	@ 02,01 SAY "Fieldname : "+fn
	@ 03,01 SAY "Fieldtype : "+ft
	SELECT 1
	SELECT 2
	@ 08,01 SAY "                 Absolute   Relative    Adjusted    Cumulative"
	@ 09,01 SAY "Response           Freq     Freq (%)    Freq (%)     Freq (%)"
	
	DO displine WITH 11,"Option 1",na,RECS,valid,cumfreq
	
	DO displine WITH 13,"Option 2",nb,RECS,valid,cumfreq
	
	nva = 15
	
	IF high >= 3 THEN
		DO displine WITH nva,"Option 3",nc,RECS,valid,cumfreq
		nva = 17
	ENDIF
	
	IF high >= 4 THEN
		DO displine WITH nva,"Option 4",nd,RECS,valid,cumfreq
		nva = 19
	ENDIF
	
	IF high >= 5 THEN
		DO displine WITH nva,"Option 5",ne,RECS,valid,cumfreq
		nva = 21
	ENDIF
	
	IF high >= 6 THEN
		DO displine WITH nva,"Option 6",nf,RECS,valid,cumfreq
		nva = 23
	ENDIF
	
	DO displine WITH nva,"Invalid Answer",invalid,RECS,valid,100
	
	@ nva+1,18 SAY "------"
	@ nva+1,29 SAY "------"
	@ nva+1,43 SAY "-------"
	@ nva+2,01 SAY "Total:"
	@ nva+2,19 SAY STR(RECS,3,0)
	@ nva+2,31 SAY "100.0"
	@ nva+2,43 SAY "100.0"
	
	@ nva+4,04 SAY "Valid Cases: "+STR(valid,3,0)+"     Invalid Cases: "+STR(invalid,3,0)
	SET DEVICE TO SCREEN
	?"Calculating Advanced Statistical Functions"
	SET DEVICE TO PRINT
	DO AVERAGE   
	@ nva+6,04 SAY "Average: "+STR(avg,5,3) 
	DO mode1
	@ nva+7,04 SAY "Mode   : "+STR(omde,1,0)
	DO median
	@ nva+8,04 SAY "Median : "+STR(medn,5,3)
	DO stdev
	@ nva+9,04 SAY "Std Dev: "+STR(stddev,10,8)
	SET DEVICE TO SCREEN
	SELECT 2
	SKIP
	
ENDDO
USE
ERASE structure.dbf
SELECT 1
EJECT
SET STATUS ON
SET PROCEDURE TO 
RETURN
*: EOF: BASCSTAT.PRG
