* BARINDEX.PRG
* Function to display a progress bar while indexing
* Example call: BAR_INDEX("CUSTOMER","LASTNAME+FIRSTNAME","CUSTNAME",12)
* Increases indexing time by maybe 60% or so
* Freely adapted from Rick Spence's Clipper 5.0 book and the GAUGE.PRG
* supplied with 5.0, but is compatible with Summer '87
*
* By Glenn Alcott - CIS 76044,747

FUNC BAR_INDEX
* Parameters: DBF name, key expression, NTX file name, row for display
PARAM DBFILE,KEYEXP,NTXFILE,ROW
USE (DBFILE)
KEYLEN=LEN(KEYEXP)  && store length of key expression
KEYEXP_NEW=KEYEXP+"+BAR_DISP("+LTRIM(STR(ROW,2,0))+")"
INDEX ON &KEYEXP_NEW TO &NTXFILE
* The BAR_DISP function may not get beyond 99%, so this is displayed to
* let the user know it actually finished.
@ ROW,38 SAY "100"
* Eliminate the UDF reference from the key stored in the index file.
* Key begins at offset 22 - write original key and fill with nulls up to
* 250 characters (the maximum length of a key expression).  The index must
* be closed before doing this.
CLOSE INDEXES
NTX_HANDLE=FOPEN(NTXFILE+".NTX",2)
FSEEK(NTX_HANDLE,22,0)
FWRITE(NTX_HANDLE,KEYEXP+REPL(CHR(0),250-KEYLEN))
FCLOSE(NTX_HANDLE)
RETURN ""

FUNC BAR_DISP
PARAM ROW
* When Clipper evaluates the index expression initially, it goes to EOF.
* At this point we display the box, but not the percentage, since it would
* show 100% before it even started!
PERCENT=IIF(EOF(),-1,RECNO()/RECCOUNT()*100)
IF PERCENT=-1
  @ ROW,0 TO ROW+2,79 DOUBLE
  @ ROW,27 SAY " INDEXING:    % COMPLETE "
ELSE
  IF RECNO() % 10 = 0   && update only every 10 records, for a little more speed
    @ ROW,38 SAY STR(PERCENT,3,0)
    @ ROW+1,1 SAY REPL("",ROUND(PERCENT*.78,0))  && bar is 78 chars max
  ENDIF
ENDIF
RETURN ""
