*-- PROGRAM: BARDEMO.PRG
*-- Author:  Roy Lee Smith, Jr.
*-- Date:    03/28/88
*-- Purpose: demonstrates the use of the BarGraph procedure
declare v[4], l[4]

v[1] = 20
v[2] = 35
v[3] = 50
v[4] = 28

l[1] = 'Winter'
l[2] = 'Spring'
l[3] = 'Summer'
l[4] = 'Fall'

tit = '1987 Sales (in thousands of dollars)'
t = .t.
s = 3
do bargraph with v,l,s,t,tit
return



*-- PROCEDURE BarGraph
*-- Author:  Roy Lee Smith, Jr.
*-- Date:    03/28/88
*-- Purpose: Draws a simple bar graph (histogram) using character graphics

*-- Parameters
*-- ==========
*--     values = an array of numeric values to be plotted
*--     labels = an parrallel array of character strings for labeling
*--              the corresponding values
*--     scale  = an integer to be multiplied by 20 (the number of lines
*--              in the graph) and used to scale the graph; if set to
*--              zero, the scale will be adjusted to fit the maximum
*--              value
*--     at_top = a Boolean value to determine placement of the graph
*--              on the page: true = top half of page, false = bottom
*--     title  = a character string to be used as the title of the graph

*-- Assumptions
*-- ===========
*-- 1. the values array contains at least 1 and no more than 30 elements
*--    of numeric type
*-- 2. the values are non-negative
*-- 3. the labels array contains a number of character strings equal
*--    to the number of elements in the values array
*-- 4. the scale is at least 1
*-- 5. the printer is online and ready

*-- Notes:
*-- ======
*-- 1. The resolution of the graph produced is inversely related to the
*--    scale value, ie. the bigger the scale the lower the resolution.
*--    This is due to the use of character graphics rather than true
*--    graphics.  For example, with a scale factor of 10, the values 2 and
*--    9 would both be represented by a single ASCII character 219.
*-- 2. Feel free to use this as you see fit.  If you make any useful
*--    modifications, please make them available to me and to others.
*--    I may be contacted at:
*--            The University of Alabama
*--            Natural Resources Center
*--            P.O. Box 6282
*--            Tuscaloosa, AL  35487
*--            (205) 340-4520

*-- Warning: this procedure does little error checking!



procedure bargraph
parameters values,labels,scale,at_top,title

private currline,titleline,topgraph,botgraph,pos,lastelem,lftmarg,lastline
private temp,i,done,barwidth

set device to print
lftmarg = 10
if at_top
   currline  = 0
   titleline = 6
   topgraph  = 8
   bottgraph = 27
   lastline  = 32
else
   currline  = 33
   titleline = 35
   topgraph  = 38
   bottgraph = 57
   lastline  = 65
endif

*-- determine the last element in the array
lastelem = 1
do while type('values[lastelem]') = 'N'
   lastelem = lastelem + 1
enddo
lastelem = lastelem - 1
barwidth = int(60/lastelem)

*-- if scale is zero, automatically set it
if scale = 0
   temp = 0
   for i = 1 to lastelem               &&- find the max value
      if values[i] > temp
         temp = values[i]
      endif
   next
   if temp%20 = 0                      &&- set the scale to accomodate
      scale = temp/20                  &&- the max value
   else
      scale = (temp/20) + 1
   endif
endif

*-- plot the graph
done = .f.
do while currline <> lastline
   do case
   case currline = titleline
      @currline,((barwidth*lastelem)/2)-(len(trim(title))/2) + lftmarg say title

   case (currline >= topgraph) .and. (currline <= bottgraph)
      if currline%2 = 0
         @currline,lftmarg-3 say str(((bottgraph+1)-currline)*scale,3,0)
      endif
      @currline,lftmarg+1 say chr(180)
      for pos = 1 to lastelem
         if values[pos] >= ((bottgraph+1)-currline) * scale
            @currline,(lftmarg+2)+(pos-1)*barwidth say replicate(chr(219),barwidth-1)
         endif
      next

   case currline = bottgraph + 1
      @currline,lftmarg+1 say chr(192)
      for pos = 1 to lastelem
         if values[pos] > 0
            @currline,(lftmarg+2)+((pos-1)*barwidth) say replicate(chr(223),barwidth-1)+chr(196)
         else
            @currline,(lftmarg+2)+((pos-1)*barwidth) say replicate(chr(196),barwidth)
         endif
      next

   case currline = bottgraph + 2
      for pos = 1 to lastelem
        @currline,(lftmarg+2)+((pos-1)*barwidth) say substr(labels[pos]+space(barwidth),1,barwidth)
      next

   endcase
   currline = currline + 1
enddo
set device to screen
return
