********************************
**
** Module:  Barfunc.prg
**
**
********************************


********************************
**
** OpenWand
**
** Opens the Comm port (if required) for the barcode reader
**
** -- CAUTION -- Only checking is the existence of the comm port.
**
** return logical value to indicate success/failure
**
********************************

function OpenWand
parameter aPort, aBaud, aWordlen, aParity, aStopbits

   if pcount() < 5
      aStopbits = 1
   endif
   if pcount() < 4
      aParity = 1
   endif
   if pcount() < 3
      aWordlen = 8
   endif
   if pcount() < 2
      aBaud = 19200
   endif
   if pcount() < 1
      aPort = 0
   endif

   if aPort > 0
      if DevicePres(aPort)
         if (OpenComm(aPort, 64, 64)) = 0       && very small buffers needed
            if (SetBaud(aPort, aBaud, aParity, aStopbits, aWordlen)) = 0
               return .T.
            endif
         endif
      endif
   endif

return .F.




********************************
**
** CloseWand
**
** Closes the Comm Port (if required)
**
** Checks to see that Port Exists
**
** Return logical value indicating success/failure
**
********************************

function CloseWand
parameter aPort

   if aPort > 0
      if DevicePres(aPort)
         CloseComm(aPort)
      else
         return .F.
      endif
   endif

return .T.



********************************
**
** ReadWand
**
** Scans the  keyboard and the barcode Port for input.
** If keyboard input is found before the entire length of barcode
** is received, the barcode is dropped and the rest of the input
** MUST come from the keyboard
**
** # # CAUTION # #  this routine uses the READ command and CLEARS GETS
**     if a Comm Port is used:   mPort must be 1 or 2
**          and the port MUST have been opened
**
** returns a string or NULL STRING on error or escape
**
********************************

function ReadWand
parameter aLen, aPort, aRow, aCol, aColor
PRIVATE mData, mStr, mChr, mLen, mColor, mGetOut

   if pcount() < 5
      aColor = ColorOf("enh")
   endif
   if pcount() < 4
      aCol = col()
   endif
   if pcount() < 3
      aRow = row()
   endif
   if pcount() < 2
      aPort = 0
   endif
   if pcount() < 1
      aLen = 10
   endif

   mColor = setcolor(aColor)
   if aPort > 0                  && clear the comm buffer, if any
      if !RxEmpty(aPort)
         RxFlush(aPort)
      endif
   endif
   do while nextkey() # 0        && clear the keyboard buffer
      inkey()
   enddo

   mData = space(aLen)
   @ aRow, aCol get mData        picture replicate("X", aLen)
   CursorTo(aRow, aCol)
   clear gets

   mGetOut = .F.
   do while .T.               && check both devices
      if nextkey() # 0
         exit
      endif
      if aPort > 0
         if !RxEmpty(aPort)
            mLen = 0
            mStr = ""
            do while !RxEmpty(aPort) .and. mLen < aLen
               mChr = RxChar(aPort)
               if mChr < 0
                  mGetOut = .T.
                  exit
               endif
               mStr = mStr + chr(mChr)
               mLen = mLen + 1
            enddo
            if mGetOut
               exit
            endif
            if mLen >= aLen            && max length reached
               if !RxEmpty(aPort)      && purge any exterraneous characters
                  RxFlush(aPort)
               endif
               keyboard mStr           && fill the keyboard (clears it first)
               exit                    && let the keyboard read the chars
            endif
         endif
      endif
   enddo
   if !mGetOut
      @ aRow, aCol get mData        picture replicate("X", aLen)
      read
   endif
   if lastkey() = 27 .or. mGetOut
      mData = ""
   endif

   do while nextkey() # 0           && be sure keyboard is purged
      inkey()
   enddo
   if aPort > 0
      if !RxEmpty(aPort)
         RxFlush(aPort)                && same with comm port
      endif
   endif
   setcolor(mColor)

return mData

