* vtbargen.prg


procedure Initbar
parameter LaserCodes

public BAR[126], PreAmble, PostAmble
private NB, WB, NS, WS

   if pcount() < 1
      LaserCodes = .F.
   endif

   if LaserCodes

      * Setup Laser Printer (HP)
      Small_bar = 3                             && points wide
      Wide_bar = round(Small_Bar * 2.25, 0)     && approx. 7 points

      * code for narrow bar
      NB = chr(Escape)+"*c"+transform(small_bar,'99')+"a"+;
                  ltrim(rtrim(str(1*50)))+;
                  "b0P"+chr(Escape)+"*p+"+transform(small_bar,'99')+"X"
      * code for wide bar
      WB = chr(Escape)+"*c"+transform(wide_bar,'99')+"a"+;
                  ltrim(rtrim(str(1*50)))+;
                  "b0P"+chr(Escape)+"*p+"+transform(wide_bar,'99')+"X"
      * code for narrow space
      NS = chr(Escape)+"*p+"+transform(small_bar,'99')+"X"
      * code for wide space
      WS = chr(Escape)+"*p+"+transform(wide_bar,'99')+"X"

      * adjust cursor position to start at top of line and return to bottom of line
      Start_Code = chr(Escape)+"*p-50Y"      && move UP (-) 50/300th (1/6) of an inch
      End_Code = chr(Escape)+"*p+50Y"        && move Down (+) 50/300th (1/6) of an inch

   else

      ***** define Epson bars and spaces
      NS = chr(0) + chr(0)                        && NO pins, 2 times
      WS = chr(0) + chr(0) + chr(0) + chr(0)      && NO pins, 4 times
      NB = chr(255)                               && ALL pins, 1 time
      WB = chr(255) + chr(255) + chr(255)         && ALL pins, 3 times

      Start_Code = ""
      End_Code = ""

   endif

   * Define the Codes 3 of 9 in terms of nb, wb, ns and ws
*   BAR[00] = NB+NS+NB+WS+NB+WS+NB+WS+NB + NS + WB+WS+NB+NS+NB+NS+NB+NS+WB\
* can't define code[00] ... array's don't allow it
   BAR[01] = NB+WS+NB+WS+NB+WS+NB+NS+NB + NS + WB+NS+NB+NS+NB+WS+NB+NS+WB
   BAR[02] = NB+WS+NB+WS+NB+WS+NB+NS+NB + NS + NB+NS+WB+NS+NB+WS+NB+NS+WB
   BAR[03] = NB+WS+NB+WS+NB+WS+NB+NS+NB + NS + WB+NS+WB+NS+NB+WS+NB+NS+NB
   BAR[04] = NB+WS+NB+WS+NB+WS+NB+NS+NB + NS + NB+NS+NB+NS+WB+WS+NB+NS+WB
   BAR[05] = NB+WS+NB+WS+NB+WS+NB+NS+NB + NS + WB+NS+NB+NS+WB+WS+NB+NS+NB
   BAR[06] = NB+WS+NB+WS+NB+WS+NB+NS+NB + NS + NB+NS+WB+NS+WB+WS+NB+NS+NB
   BAR[07] = NB+WS+NB+WS+NB+WS+NB+NS+NB + NS + NB+NS+NB+NS+NB+WS+WB+NS+WB
   BAR[08] = NB+WS+NB+WS+NB+WS+NB+NS+NB + NS + WB+NS+NB+NS+NB+WS+WB+NS+NB
   BAR[09] = NB+WS+NB+WS+NB+WS+NB+NS+NB + NS + NB+NS+WB+NS+NB+WS+WB+NS+NB
   BAR[10] = NB+WS+NB+WS+NB+WS+NB+NS+NB + NS + NB+NS+NB+NS+WB+WS+WB+NS+NB
   BAR[11] = NB+WS+NB+WS+NB+WS+NB+NS+NB + NS + WB+NS+NB+NS+NB+NS+NB+WS+WB
   BAR[12] = NB+WS+NB+WS+NB+WS+NB+NS+NB + NS + NB+NS+WB+NS+NB+NS+NB+WS+WB
   BAR[13] = NB+WS+NB+WS+NB+WS+NB+NS+NB + NS + WB+NS+WB+NS+NB+NS+NB+WS+NB
   BAR[14] = NB+WS+NB+WS+NB+WS+NB+NS+NB + NS + NB+NS+NB+NS+WB+NS+NB+WS+WB
   BAR[15] = NB+WS+NB+WS+NB+WS+NB+NS+NB + NS + WB+NS+NB+NS+WB+NS+NB+WS+NB
   BAR[16] = NB+WS+NB+WS+NB+WS+NB+NS+NB + NS + NB+NS+WB+NS+WB+NS+NB+WS+NB
   BAR[17] = NB+WS+NB+WS+NB+WS+NB+NS+NB + NS + NB+NS+NB+NS+NB+NS+WB+WS+WB
   BAR[18] = NB+WS+NB+WS+NB+WS+NB+NS+NB + NS + WB+NS+NB+NS+NB+NS+WB+WS+NB
   BAR[19] = NB+WS+NB+WS+NB+WS+NB+NS+NB + NS + NB+NS+WB+NS+NB+NS+WB+WS+NB
   BAR[20] = NB+WS+NB+WS+NB+WS+NB+NS+NB + NS + NB+NS+NB+NS+WB+NS+WB+WS+NB
   BAR[21] = NB+WS+NB+WS+NB+WS+NB+NS+NB + NS + WB+WS+NB+NS+NB+NS+NB+NS+WB
   BAR[22] = NB+WS+NB+WS+NB+WS+NB+NS+NB + NS + NB+WS+WB+NS+NB+NS+NB+NS+WB
   BAR[23] = NB+WS+NB+WS+NB+WS+NB+NS+NB + NS + WB+WS+WB+NS+NB+NS+NB+NS+NB
   BAR[24] = NB+WS+NB+WS+NB+WS+NB+NS+NB + NS + NB+WS+NB+NS+WB+NS+NB+NS+WB
   BAR[25] = NB+WS+NB+WS+NB+WS+NB+NS+NB + NS + WB+WS+NB+NS+WB+NS+NB+NS+NB
   BAR[26] = NB+WS+NB+WS+NB+WS+NB+NS+NB + NS + NB+WS+WB+NS+WB+NS+NB+NS+NB
   BAR[27] = NB+NS+NB+WS+NB+WS+NB+WS+NB + NS + WB+NS+NB+NS+NB+WS+NB+NS+WB
   BAR[28] = NB+NS+NB+WS+NB+WS+NB+WS+NB + NS + NB+NS+WB+NS+NB+WS+NB+NS+WB
   BAR[29] = NB+NS+NB+WS+NB+WS+NB+WS+NB + NS + WB+NS+WB+NS+NB+WS+NB+NS+NB
   BAR[30] = NB+NS+NB+WS+NB+WS+NB+WS+NB + NS + NB+NS+NB+NS+WB+WS+NB+NS+WB
   BAR[31] = NB+NS+NB+WS+NB+WS+NB+WS+NB + NS + WB+NS+NB+NS+WB+WS+NB+NS+NB

   BAR[32] = NB+WS+WB+NS+NB+NS+WB+NS+NB       && " " SPACE
   BAR[33] = NB+WS+NB+WS+NB+NS+NB+WS+NB + NS + WB+NS+NB+NS+NB+WS+NB+NS+WB    && "!"
   BAR[34] = NB+WS+NB+WS+NB+NS+NB+WS+NB + NS + NB+NS+WB+NS+NB+WS+NB+NS+WB    && """
   BAR[35] = NB+WS+NB+WS+NB+NS+NB+WS+NB + NS + WB+NS+WB+NS+NB+WS+NB+NS+NB    && "#"
   BAR[36] = NB+WS+NB+WS+NB+NS+NB+WS+NB + NS + NB+NS+NB+NS+WB+WS+NB+NS+WB    && "$"
   BAR[37] = NB+WS+NB+WS+NB+NS+NB+WS+NB + NS + WB+NS+NB+NS+WB+WS+NB+NS+NB    && "%"
   BAR[38] = NB+WS+NB+WS+NB+NS+NB+WS+NB + NS + NB+NS+WB+NS+WB+WS+NB+NS+NB    && "&"
   BAR[39] = NB+WS+NB+WS+NB+NS+NB+WS+NB + NS + NB+NS+NB+NS+NB+WS+WB+NS+WB    && "'"
   BAR[40] = NB+WS+NB+WS+NB+NS+NB+WS+NB + NS + WB+NS+NB+NS+NB+WS+WB+NS+NB    && "("
   BAR[41] = NB+WS+NB+WS+NB+NS+NB+WS+NB + NS + NB+NS+WB+NS+NB+WS+WB+NS+NB    && ")"
   BAR[42] = NB+WS+NB+WS+NB+NS+NB+WS+NB + NS + NB+NS+NB+NS+WB+WS+WB+NS+NB    && "*"
   BAR[43] = NB+WS+NB+WS+NB+NS+NB+WS+NB + NS + WB+NS+NB+NS+NB+NS+NB+WS+WB    && "+"
   BAR[44] = NB+WS+NB+WS+NB+NS+NB+WS+NB + NS + NB+NS+WB+NS+NB+NS+NB+WS+WB    && ","
   BAR[45] = NB+WS+NB+NS+NB+NS+WB+NS+WB       && "-"
   BAR[46] = WB+WS+NB+NS+NB+NS+WB+NS+NB       && ".".
   BAR[47] = NB+WS+NB+WS+NB+NS+NB+WS+NB + NS + WB+NS+NB+NS+WB+NS+NB+WS+NB      && "/"

   BAR[48] = NB+NS+NB+WS+WB+NS+WB+NS+NB       && "0"
   BAR[49] = WB+NS+NB+WS+NB+NS+NB+NS+WB       && "1"
   BAR[50] = NB+NS+WB+WS+NB+NS+NB+NS+WB       && "2"
   BAR[51] = WB+NS+WB+WS+NB+NS+NB+NS+NB       && "3"
   BAR[52] = NB+NS+NB+WS+WB+NS+NB+NS+WB       && "4"
   BAR[53] = WB+NS+NB+WS+WB+NS+NB+NS+NB       && "5"
   BAR[54] = NB+NS+WB+WS+WB+NS+NB+NS+NB       && "6"
   BAR[55] = NB+NS+NB+WS+NB+NS+WB+NS+WB       && "7"
   BAR[56] = WB+NS+NB+WS+NB+NS+WB+NS+NB       && "8"
   BAR[57] = NB+NS+WB+WS+NB+NS+WB+NS+NB       && "9"

   BAR[58] = NB+WS+NB+WS+NB+NS+NB+WS+NB + NS + NB+WS+WB+NS+WB+NS+NB+NS+NB     && ":"
   BAR[59] = NB+NS+NB+WS+NB+WS+NB+WS+NB + NS + NB+NS+WB+NS+WB+WS+NB+NS+NB     && ";"
   BAR[60] = NB+NS+NB+WS+NB+WS+NB+WS+NB + NS + NB+NS+NB+NS+NB+WS+WB+NS+WB     && "<"
   BAR[61] = NB+NS+NB+WS+NB+WS+NB+WS+NB + NS + WB+NS+NB+NS+NB+WS+WB+NS+NB     && "="
   BAR[62] = NB+NS+NB+WS+NB+WS+NB+WS+NB + NS + NB+NS+WB+NS+NB+WS+WB+NS+NB     && ">"
   BAR[63] = NB+NS+NB+WS+NB+WS+NB+WS+NB + NS + NB+NS+NB+NS+WB+WS+WB+NS+NB     && "?"
   BAR[64] = NB+NS+NB+WS+NB+WS+NB+WS+NB + NS + NB+WS+WB+NS+NB+NS+NB+NS+WB     && "@"

   BAR[65] = WB+NS+NB+NS+NB+WS+NB+NS+WB       && "A"
   BAR[66] = NB+NS+WB+NS+NB+WS+NB+NS+WB       && "B"
   BAR[67] = WB+NS+WB+NS+NB+WS+NB+NS+NB       && "C"
   BAR[68] = NB+NS+NB+NS+WB+WS+NB+NS+WB       && "D"
   BAR[69] = WB+NS+NB+NS+WB+WS+NB+NS+NB       && "E"
   BAR[70] = NB+NS+WB+NS+WB+WS+NB+NS+NB       && "F"
   BAR[71] = NB+NS+NB+NS+NB+WS+WB+NS+WB       && "G"
   BAR[72] = WB+NS+NB+NS+NB+WS+WB+NS+NB       && "H"
   BAR[73] = NB+NS+WB+NS+NB+WS+WB+NS+NB       && "I"
   BAR[74] = NB+NS+NB+NS+WB+WS+WB+NS+NB       && "J"
   BAR[75] = WB+NS+NB+NS+NB+NS+NB+WS+WB       && "K"
   BAR[76] = NB+NS+WB+NS+NB+NS+NB+WS+WB       && "L"
   BAR[77] = WB+NS+WB+NS+NB+NS+NB+WS+NB       && "M"
   BAR[78] = NB+NS+NB+NS+WB+NS+NB+WS+WB       && "N"
   BAR[79] = WB+NS+NB+NS+WB+NS+NB+WS+NB       && "O"
   BAR[80] = NB+NS+WB+NS+WB+NS+NB+WS+NB       && "P"
   BAR[81] = NB+NS+NB+NS+NB+NS+WB+WS+WB       && "Q"
   BAR[82] = WB+NS+NB+NS+NB+NS+WB+WS+NB       && "R"
   BAR[83] = NB+NS+WB+NS+NB+NS+WB+WS+NB       && "S"
   BAR[84] = NB+NS+NB+NS+WB+NS+WB+WS+NB       && "T"
   BAR[85] = WB+WS+NB+NS+NB+NS+NB+NS+WB       && "U"
   BAR[86] = NB+WS+WB+NS+NB+NS+NB+NS+WB       && "V"
   BAR[87] = WB+WS+WB+NS+NB+NS+NB+NS+NB       && "W"
   BAR[88] = NB+WS+NB+NS+WB+NS+NB+NS+WB       && "X"
   BAR[89] = WB+WS+NB+NS+WB+NS+NB+NS+NB       && "Y"
   BAR[90] = NB+WS+WB+NS+WB+NS+NB+NS+NB       && "Z"

   BAR[91] = NB+NS+NB+WS+NB+WS+NB+WS+NB + NS + WB+NS+NB+NS+NB+NS+NB+WS+WB    && "]"
   BAR[92] = NB+NS+NB+WS+NB+WS+NB+WS+NB + NS + NB+NS+WB+NS+NB+NS+NB+WS+WB    && "\"
   BAR[93] = NB+NS+NB+WS+NB+WS+NB+WS+NB + NS + WB+NS+WB+NS+NB+NS+NB+WS+NB    && "["
   BAR[94] = NB+NS+NB+WS+NB+WS+NB+WS+NB + NS + NB+NS+NB+NS+WB+NS+NB+WS+WB    && "^"
   BAR[95] = NB+NS+NB+WS+NB+WS+NB+WS+NB + NS + WB+NS+NB+NS+WB+NS+NB+WS+NB    && "_"
   BAR[96] = NB+NS+NB+WS+NB+WS+NB+WS+NB + NS + WB+WS+WB+NS+NB+NS+NB+NS+NB    && "`"

   BAR[97] = NB+WS+NB+NS+NB+WS+NB+WS+NB + NS + WB+NS+NB+NS+NB+WS+NB+NS+WB     && "a"
   BAR[98] = NB+WS+NB+NS+NB+WS+NB+WS+NB + NS + NB+NS+WB+NS+NB+WS+NB+NS+WB     && "b"
   BAR[99] = NB+WS+NB+NS+NB+WS+NB+WS+NB + NS + WB+NS+WB+NS+NB+WS+NB+NS+NB     && "c"
   BAR[100] = NB+WS+NB+NS+NB+WS+NB+WS+NB + NS + NB+NS+NB+NS+WB+WS+NB+NS+WB     && "d"
   BAR[101] = NB+WS+NB+NS+NB+WS+NB+WS+NB + NS + WB+NS+NB+NS+WB+WS+NB+NS+NB     && "e"
   BAR[102] = NB+WS+NB+NS+NB+WS+NB+WS+NB + NS + NB+NS+WB+NS+WB+WS+NB+NS+NB     && "f"
   BAR[103] = NB+WS+NB+NS+NB+WS+NB+WS+NB + NS + NB+NS+NB+NS+NB+WS+WB+NS+WB     && "g"
   BAR[104] = NB+WS+NB+NS+NB+WS+NB+WS+NB + NS + WB+NS+NB+NS+NB+WS+WB+NS+NB     && "h"
   BAR[105] = NB+WS+NB+NS+NB+WS+NB+WS+NB + NS + NB+NS+WB+NS+NB+WS+WB+NS+NB     && "i"
   BAR[106] = NB+WS+NB+NS+NB+WS+NB+WS+NB + NS + NB+NS+NB+NS+WB+WS+WB+NS+NB     && "j"
   BAR[107] = NB+WS+NB+NS+NB+WS+NB+WS+NB + NS + WB+NS+NB+NS+NB+NS+NB+WS+WB     && "k"
   BAR[108] = NB+WS+NB+NS+NB+WS+NB+WS+NB + NS + NB+NS+WB+NS+NB+NS+NB+WS+WB     && "l"
   BAR[109] = NB+WS+NB+NS+NB+WS+NB+WS+NB + NS + WB+NS+WB+NS+NB+NS+NB+WS+NB     && "m"
   BAR[110] = NB+WS+NB+NS+NB+WS+NB+WS+NB + NS + NB+NS+NB+NS+WB+NS+NB+WS+WB     && "n"
   BAR[111] = NB+WS+NB+NS+NB+WS+NB+WS+NB + NS + WB+NS+NB+NS+WB+NS+NB+WS+NB     && "o"
   BAR[112] = NB+WS+NB+NS+NB+WS+NB+WS+NB + NS + NB+NS+WB+NS+WB+NS+NB+WS+NB     && "p"
   BAR[113] = NB+WS+NB+NS+NB+WS+NB+WS+NB + NS + NB+NS+NB+NS+NB+NS+WB+WS+WB     && "q"
   BAR[114] = NB+WS+NB+NS+NB+WS+NB+WS+NB + NS + WB+NS+NB+NS+NB+NS+WB+WS+NB     && "r"
   BAR[115] = NB+WS+NB+NS+NB+WS+NB+WS+NB + NS + NB+NS+WB+NS+NB+NS+WB+WS+NB     && "s"
   BAR[116] = NB+WS+NB+NS+NB+WS+NB+WS+NB + NS + NB+NS+NB+NS+WB+NS+WB+WS+NB     && "t"
   BAR[117] = NB+WS+NB+NS+NB+WS+NB+WS+NB + NS + WB+WS+NB+NS+NB+NS+NB+NS+WB     && "u"
   BAR[118] = NB+WS+NB+NS+NB+WS+NB+WS+NB + NS + NB+WS+WB+NS+NB+NS+NB+NS+WB     && "v"
   BAR[119] = NB+WS+NB+NS+NB+WS+NB+WS+NB + NS + WB+WS+WB+NS+NB+NS+NB+NS+NB     && "w"
   BAR[120] = NB+WS+NB+NS+NB+WS+NB+WS+NB + NS + NB+WS+NB+NS+WB+NS+NB+NS+WB     && "x"
   BAR[121] = NB+WS+NB+NS+NB+WS+NB+WS+NB + NS + WB+WS+NB+NS+WB+NS+NB+NS+NB     && "y"
   BAR[122] = NB+WS+NB+NS+NB+WS+NB+WS+NB + NS + NB+WS+WB+NS+WB+NS+NB+NS+NB     && "z"

   BAR[123] = NB+NS+NB+WS+NB+WS+NB+WS+NB + NS + NB+NS+WB+NS+WB+NS+NB+WS+NB     && "{"
   BAR[124] = NB+NS+NB+WS+NB+WS+NB+WS+NB + NS + NB+NS+NB+NS+NB+NS+WB+WS+WB     && "|"
   BAR[125] = NB+NS+NB+WS+NB+WS+NB+WS+NB + NS + WB+NS+NB+NS+NB+NS+WB+WS+NB     && "}"
   BAR[126] = NB+NS+NB+WS+NB+WS+NB+WS+NB + NS + NB+NS+WB+NS+NB+NS+WB+WS+NB     && "~"

   Preamble = Start_Code + NB+WS+NB+NS+WB+NS+WB+NS+NB + NS
   Postamble = NB+WS+NB+NS+WB+NS+WB+NS+NB + End_Code

return



***************************************
** PrintBarLine
**
** Outputs lines of text to the selected printer
***************************************


procedure PrintBarLine
parameter UseLaser, Barcode, Msg1, Msg2
private Bars, X, E1, E2, O1, O2, N1, N2

   if pcount() < 5
      NumUp = 1
   endif
   if pcount() < 4
      Msg2 = ""
   endif
   if pcount() < 3
      Msg1 = ""
   endif

   * printer must be turned ON and set to correct printer
   if UseLaser

      for X = 1 to 2
         ? space(3) + Preamble
         for Y = 1 to len(Barcode)
            ?? BAR[ asc(substr(Barcode, Y, 1)) ]
            ?? chr(Escape)+"*p+"+transform(3,'99')+"X"
         next

         ?? Postamble

         if X = 1
            ?? space(3) + Msg1
         else
            ?? space(3) + Msg2
         endif
      next

      ? space((len(Barcode) / 2) + 3) + Barcode

   else                                             && use Epson/IBM method

	  ***** calculate N1 and N2 values for dot graphics command
      cols = len(PreAmble)
      E1 = cols % 256
      E2 = INT(cols/256)

      cols = len(PostAmble)
      O1 = cols % 256
      O2 = INT(cols/256)

      ***** set printer to 2/216 lines per inch Line Feed
      ? chr(Escape)+chr(51)+chr(2)

      ***** print barcoded MESSAGE *****
      for X = 1 to 3                                && 3 lines of bars

         ***** print a few blanks to separate the left margin
         ?? chr(Escape) + "L" + chr(30) + chr(0) + replicate(CHR(0),30)

         ?? chr(Escape) + "L" + chr(E1) + chr(E2) + PreAmble

         ***** print barcode one character at a time on Epson
         for Y = 1 to len(Barcode)                  && for each character
            * include a Narrow Space between characters
            cols = len( BAR[ asc(substr(Barcode, Y, 1)) ] ) + 2
            N1 = cols % 256
            N2 = INT(cols/256)

            ?? chr(Escape) + "L" + chr(N1) + chr(N2) +;
               BAR[ asc(substr(Barcode, Y, 1)) ] + chr(0) + chr(0)
         next

         ?? chr(Escape) + "L" + chr(O1) + chr(O2) + PostAmble

         if X = 1
            ?? space(3) + Msg1
         elseif X = 3            && put a space between them
            ?? space(3) + Msg2
         endif

		 ***** perform 23 * 2/216 line feeds
		 ?? chr(Escape)+chr(74)+chr(24)+chr(13)

      next

      ***** set printer to 10cpi
      ?? chr(Escape) + chr(50)                      && set printer to 6 lpi

      ?? space((len(Barcode) / 2) + 3) + Barcode    && 3rd line (1/2 inch)
   endif

return

