*Ŀ
*                     BARDEMO.PRG version 1.0 07/13/89                     
*           Author: Todd C. MacDonald  Compuserve ID: 73767,2242           
*
*
* This program demonstrates the use of routines to display a "percentage
* complete" thermometer-type bar.  You may compile and link these routines
* into your Clipper Summer '87 applications.
*
* The routines contained in this file were written in Clipper.  You may
* freely use and distribute this code, provided you adhere to the following
* restrictions:
*
*     The source (BARDEMO.PRG) is supplied in its original, unmodified form.
*      I recommend you distribute the compressed file BARDEMO.ZIP.
*
*     No fee may be charged for distribution.
*
* DISCLAIMER ͻ
* I disclaim any liability for damage resulting from the use or mis-use of 
* the routines contained in the BARDEMO.PRG file.                          
*ͼ
*
* Clipper is a trademark of Nantucket Corporation and is copyrighted and all
* that jazz...
*
*  On with the demo... 
*
* To compile and link this demo program, type the following:
*
*   C> CLIPPER BARDEMO
*   C> PLINK86 FI BARDEMO LIB CLIPPER,EXTEND
*        -OR-
*      LINK BARDEMO,,,CLIPPER+EXTEND
*
* To run the demo:
*
*   C> BARDEMO
*
*
*  BARDEMO source begins here 

* Make things pretty
set cursor off
clear

* Initialize the denominator ( Hint: This could be RECCOUNT() )
lLoopCount = 250

* Initialize and draw the bar scale on the screen at row 5, col 24, length 32
InitBar(5, 24, 32)

* Add our own statistical stuff
@ 3, 24 say 'Iteration:            % Complete'

* Perform the process
for I = 1 to lLoopCount

  * Display the current statistics
  @ 3, 35 say I pict '999'
  @ 3, 43 say integer(I/lLoopCount * 100) pict '999'

  * Graphically show the percentage
  AdvanceBar(I/lLoopCount)

next

* Clean up and go home
set cursor on
quit

* Neat and easy, huh?


*  Include the following routines in your source 

procedure InitBar
*---------------*

* Author:  Todd C. MacDonald (Compuserve ID: 73767,2242)
* Syntax:  InitBar( <expN1>, <expN2>, <expN3> [, <expC1> [, <expC2> ] ] )
* Where:   <expN1> is the screen row to display the scale at
*          <expN2> is the screen column to display the scale at
*          <expN3> is the width in characters of the scale
*          <expC1> is the color used for the scale (default: "W/N")
*          <expC2> is the color used for the bar   (default: "W/N")
* Purpose: Initializes variables used by the AdvanceBar procedure and Displays a
*          "scale" of length <expN3> at row <expN1>, column <expN2> in the color
*          specified by <expC1>.  Subsequent calls to AdvanceBar will cause the
*          "bar" (displayed in the color specified by <expC2>) to advance
*          reflecting the current percentage complete.
*
parameters lRow, lCol, lWidth, lScaleColr, lBarColor
public pBarRow, pBarCol, pBarWidth, pScaleColr, pBarColor, pBarStep
private lOrigColor
pBarRow    = lRow
pBarCol    = lCol
pBarWidth  = lWidth
pScaleColr = if(pcount() > 3, lScaleColr, "W/N")
pBarColor  = if(pcount() > 4, lBarColor, "W/N")
pBarStep   = 100 / pBarWidth / 100
lOrigColor = setcolor(pScaleColr)
@ pBarRow, pBarCol say replicate('', pBarWidth)
setcolor(lOrigColor)
return


procedure AdvanceBar
*------------------*

* Author:  Todd C. MacDonald (Compuserve ID: 73767,2242)
* Syntax:  AdvanceBar( <expN> )
* Where:   <expN> is a number less than or equal to 1
* Purpose: Paints the bar on the scale reflecting the current percentage passed
*          in as a parameter.
*
parameters lPercent
private lOrigColor
lOrigColor = setcolor(pBarColor)
if lPercent < 1
  @ pBarRow, pBarCol say replicate('', int(lPercent/pBarStep))
else
  @ pBarRow, pBarCol say replicate('', pBarWidth)
endif
setcolor(lOrigColor)
return


function Integer
*--------------*

* Author:  Todd C. MacDonald (Compuserve ID: 73767,2242)
* Syntax:  Integer( <expN> )
* Where:   <expN> is a real value to convert to an integer
* Returns: The integer portion of <expN>.  This function is a workaround for
*          Summer 1987 versions' unreliable int() function.
*
parameters lNum
return val(left(str(lNum, 21, 10), 10))


*  End of BARDEMO.PRG 

