* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* CUGOC.LIB   Clipper Users' Group of Orange County Library Functions
*             -------------------------------------------------------
*                                 A_APPEND()
*             -------------------------------------------------------
* Author:     Stephen Hilton (Clipper Users Group of Orange County)
*             Based on the concept provided by Ira Imus.
*
* Syntax:     A_APPEND( <array> )
* 
* Purpose:    To simulate appending to an array.  What the function
*             actually does is declare an array one element larger
*             than the existing array, copies the old array to a
*             temp array, adds the contents to the bottom of the
*             temp array, copies the temp array back to the original
*             array name, and releases the temp array.
* 
* Arguments:  <array> is the array you are appending to.
* 
* Returns:    There is no return value.
* 
* Example:    USE <database>
*             SET INDEX TO <indexfile>      && index optional
* 
*             contents = <fieldname>        && fieldname or "list"
* 
*             DECLARE one[RECCOUNT()]       && define array size
* 
*             FOR i = 1 TO RECCOUNT()       && fill from database
*                  one[i] = &contents
*                SKIP                       && set pointer to next 
*             NEXT                          && record in database    
* 
*             memvar = ACHOICE(t,l,b,r,one) && display records
*             A_APPEND(one)
*             memvar = ACHOICE(t,l,b,r,one) && display records again
* 
* Library:    CUGOC.LIB
* 
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 
FUNCTION A_APPEND
PARAMETERS the_array
   old_len = LEN(the_array)
   new_len = old_len + 1
   PUBLIC temp_array[new_len]
   acopy(the_array, temp_array, 1, old_len)
   GO TOP
   SKIP old_len
   temp_array[new_len] = &contents
   RELEASE the_array
   PUBLIC the_array[new_len]
   acopy(temp_array, the_array, 1, new_len)
   RELEASE temp_array
   RETURN ("")
*eof: A_APPEND()
